/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.bdxr2;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.http.basicauth.BasicAuthClientCredentials;
import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppolid.CIdentifier;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.bdxr.smp2.participant.BDXR2ParticipantIdentifier;
import com.helger.smpclient.bdxr2.BDXR2ClientReadOnly;
import com.helger.smpclient.bdxr2.marshal.BDXR2MarshallerServiceGroup;
import com.helger.smpclient.bdxr2.marshal.BDXR2MarshallerServiceMetadata;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.httpclient.SMPHttpResponseHandlerWriteOperations;
import com.helger.smpclient.url.ISMPURLProvider;
import com.helger.smpclient.url.SMPDNSResolutionException;
import com.helger.xsds.bdxr.smp2.ServiceGroupType;
import com.helger.xsds.bdxr.smp2.ServiceMetadataType;
import com.helger.xsds.bdxr.smp2.ac.EndpointType;
import com.helger.xsds.bdxr.smp2.ac.ProcessMetadataType;
import com.helger.xsds.bdxr.smp2.ac.RedirectType;
import com.helger.xsds.bdxr.smp2.bc.IDType;
import com.helger.xsds.bdxr.smp2.bc.ParticipantIDType;
import com.helger.xsds.ccts.cct.schemamodule.IdentifierType;
import java.net.URI;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BDXR2Client
extends BDXR2ClientReadOnly {
    private static final Logger LOGGER = LoggerFactory.getLogger(BDXR2Client.class);

    public BDXR2Client(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull ISMLInfo iSMLInfo) throws SMPDNSResolutionException {
        super(iSMPURLProvider, iParticipantIdentifier, iSMLInfo);
    }

    public BDXR2Client(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull @Nonempty String string) throws SMPDNSResolutionException {
        super(iSMPURLProvider, iParticipantIdentifier, string);
    }

    public BDXR2Client(@Nonnull URI uRI) {
        super(uRI);
    }

    public void saveServiceGroup(@Nonnull ServiceGroupType serviceGroupType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)serviceGroupType, (String)"ServiceGroup");
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        String string = new BDXR2MarshallerServiceGroup().setUseSchema(this.isXMLSchemaValidation()).getAsString((Object)serviceGroupType);
        if (string == null) {
            throw new IllegalArgumentException("Failed to serialize ServiceGroup: " + serviceGroupType);
        }
        String string2 = this.getSMPHostURI() + "bdxr-smp-2/" + CIdentifier.getURIPercentEncoded((IdentifierType)serviceGroupType.getParticipantID());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BDXR2Client saveServiceGroup@" + string2);
        }
        HttpPut httpPut = new HttpPut(string2);
        httpPut.addHeader("Authorization", (Object)basicAuthClientCredentials.getRequestValue());
        httpPut.setEntity((HttpEntity)new StringEntity(string, CONTENT_TYPE_TEXT_XML));
        this.executeGenericRequest((HttpUriRequest)httpPut, new SMPHttpResponseHandlerWriteOperations());
    }

    @Nonnull
    public ServiceGroupType saveServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        ServiceGroupType serviceGroupType = new ServiceGroupType();
        serviceGroupType.setParticipantID((ParticipantIDType)new BDXR2ParticipantIdentifier(iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue()));
        this.saveServiceGroup(serviceGroupType, basicAuthClientCredentials);
        return serviceGroupType;
    }

    public void deleteServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        String string = this.getSMPHostURI() + "bdxr-smp-2/" + iParticipantIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BDXR2Client deleteServiceGroup@" + string);
        }
        HttpDelete httpDelete = new HttpDelete(string);
        httpDelete.addHeader("Authorization", (Object)basicAuthClientCredentials.getRequestValue());
        this.executeGenericRequest((HttpUriRequest)httpDelete, new SMPHttpResponseHandlerWriteOperations());
    }

    private void _saveServiceInformation(@Nonnull ServiceMetadataType serviceMetadataType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        String string = new BDXR2MarshallerServiceMetadata().setUseSchema(this.isXMLSchemaValidation()).getAsString((Object)serviceMetadataType);
        if (string == null) {
            throw new IllegalArgumentException("Failed to serialize ServiceMetadata: " + serviceMetadataType);
        }
        String string2 = this.getSMPHostURI() + "bdxr-smp-2/" + CIdentifier.getURIPercentEncoded((IdentifierType)serviceMetadataType.getParticipantID()) + "/services/" + CIdentifier.getURIPercentEncoded((IdentifierType)serviceMetadataType.getID());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BDXR2Client saveServiceRegistration@" + string2);
        }
        HttpPut httpPut = new HttpPut(string2);
        httpPut.addHeader("Authorization", (Object)basicAuthClientCredentials.getRequestValue());
        httpPut.setEntity((HttpEntity)new StringEntity(string, CONTENT_TYPE_TEXT_XML));
        this.executeGenericRequest((HttpUriRequest)httpPut, new SMPHttpResponseHandlerWriteOperations());
    }

    public void saveServiceEndpoints(@Nonnull ParticipantIDType participantIDType, @Nonnull IDType iDType, @Nonnull List<EndpointType> list, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)participantIDType, (String)"ServiceGroupID");
        ValueEnforcer.notNull((Object)iDType, (String)"DocumentTypeID");
        ValueEnforcer.notNull(list, (String)"Endpoints");
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        ServiceMetadataType serviceMetadataType = new ServiceMetadataType();
        serviceMetadataType.setSMPVersionID("2.0");
        serviceMetadataType.setID(iDType);
        serviceMetadataType.setParticipantID(participantIDType);
        ProcessMetadataType processMetadataType = new ProcessMetadataType();
        processMetadataType.getEndpoint().addAll(list);
        serviceMetadataType.addProcessMetadata(processMetadataType);
        this._saveServiceInformation(serviceMetadataType, basicAuthClientCredentials);
    }

    public void saveServiceRedirect(@Nonnull ParticipantIDType participantIDType, @Nonnull IDType iDType, @Nonnull RedirectType redirectType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)participantIDType, (String)"ServiceGroupID");
        ValueEnforcer.notNull((Object)iDType, (String)"DocumentTypeID");
        ValueEnforcer.notNull((Object)redirectType, (String)"Redirect");
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        ServiceMetadataType serviceMetadataType = new ServiceMetadataType();
        serviceMetadataType.setSMPVersionID("2.0");
        serviceMetadataType.setID(iDType);
        serviceMetadataType.setParticipantID(participantIDType);
        ProcessMetadataType processMetadataType = new ProcessMetadataType();
        processMetadataType.setRedirect(redirectType);
        serviceMetadataType.addProcessMetadata(processMetadataType);
        this._saveServiceInformation(serviceMetadataType, basicAuthClientCredentials);
    }

    public void deleteServiceRegistration(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ServiceGroupID");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocumentTypeID");
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        String string = this.getSMPHostURI() + "bdxr-smp-2/" + iParticipantIdentifier.getURIPercentEncoded() + "/services/" + iDocumentTypeIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BDXR2Client deleteServiceRegistration@" + string);
        }
        HttpDelete httpDelete = new HttpDelete(string);
        httpDelete.addHeader("Authorization", (Object)basicAuthClientCredentials.getRequestValue());
        this.executeGenericRequest((HttpUriRequest)httpDelete, new SMPHttpResponseHandlerWriteOperations());
    }
}

