/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.extension;

import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.traits.IAddableByTrait;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.serialize.JsonReader;
import com.helger.json.serialize.JsonWriterSettings;
import com.helger.smpclient.extension.SMPExtension;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xsds.bdxr.smp2.ec.SMPExtensionType;
import com.helger.xsds.bdxr.smp2.ec.SMPExtensionsType;
import com.helger.xsds.peppol.smp1.ExtensionType;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@NotThreadSafe
@MustImplementEqualsAndHashcode
public class SMPExtensionList {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMPExtensionList.class);
    private final ICommonsList<SMPExtension> m_aExtensions = new CommonsArrayList();

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<SMPExtension> extensions() {
        return this.m_aExtensions;
    }

    @Nullable
    public IJsonArray getExtensionsAsJson() {
        if (this.m_aExtensions.isEmpty()) {
            return null;
        }
        JsonArray jsonArray = new JsonArray();
        for (SMPExtension sMPExtension : this.m_aExtensions) {
            jsonArray.addIfNotNull((IAddableByTrait)sMPExtension.getAsJsonObject());
        }
        return jsonArray.isEmpty() ? null : jsonArray;
    }

    @Nullable
    public String getExtensionsAsJsonString() {
        IJsonArray iJsonArray = this.getExtensionsAsJson();
        return iJsonArray == null ? null : iJsonArray.getAsJsonString(JsonWriterSettings.DEFAULT_SETTINGS);
    }

    @Nullable
    public String getFirstExtensionXMLString() {
        if (this.m_aExtensions.isEmpty()) {
            return null;
        }
        Element element = ((SMPExtension)this.m_aExtensions.getFirst()).getAny();
        return XMLWriter.getNodeAsString((Node)element, (IXMLWriterSettings)SMPExtension.XWS);
    }

    @Nonnull
    public final EChange setExtensionAsString(@Nullable String string) {
        CommonsArrayList commonsArrayList = null;
        if (StringHelper.hasText((String)string)) {
            if (string.trim().charAt(0) == '<') {
                SMPExtension sMPExtension = SMPExtension.ofXML(string);
                if (sMPExtension != null) {
                    commonsArrayList = new CommonsArrayList((Object)sMPExtension);
                }
            } else {
                IJson iJson = JsonReader.readFromString((String)string);
                if (iJson == null || !iJson.isArray()) {
                    LOGGER.warn("Error in parsing extension JSON '" + string + "'");
                } else {
                    CommonsArrayList commonsArrayList2 = new CommonsArrayList();
                    for (IJsonObject iJsonObject : iJson.getAsArray().iteratorObjects()) {
                        SMPExtension sMPExtension = SMPExtension.ofJson(iJsonObject);
                        if (sMPExtension == null) continue;
                        commonsArrayList2.add((Object)sMPExtension);
                    }
                    if (commonsArrayList2.isNotEmpty()) {
                        commonsArrayList = commonsArrayList2;
                    }
                }
            }
        }
        if (this.m_aExtensions.equals(commonsArrayList)) {
            return EChange.UNCHANGED;
        }
        this.m_aExtensions.setAll(commonsArrayList);
        return EChange.CHANGED;
    }

    @Nullable
    @ReturnsMutableCopy
    public ExtensionType getAsPeppolExtension() {
        if (this.m_aExtensions.isEmpty()) {
            return null;
        }
        if (this.m_aExtensions.size() > 1) {
            LOGGER.warn("The Peppol data model only knows 1 extension. You have " + this.m_aExtensions.size() + " extension");
        }
        return ((SMPExtension)this.m_aExtensions.getFirst()).getAsPeppolExtension();
    }

    @Nullable
    @ReturnsMutableCopy
    public ICommonsList<com.helger.xsds.bdxr.smp1.ExtensionType> getAsBDXRExtensions() {
        if (this.m_aExtensions.isEmpty()) {
            return null;
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (SMPExtension sMPExtension : this.m_aExtensions) {
            commonsArrayList.add((Object)sMPExtension.getAsBDXRExtension());
        }
        return commonsArrayList;
    }

    @Nullable
    @ReturnsMutableCopy
    public SMPExtensionsType getAsBDXR2Extensions() {
        if (this.m_aExtensions.isEmpty()) {
            return null;
        }
        SMPExtensionsType sMPExtensionsType = new SMPExtensionsType();
        for (SMPExtension sMPExtension : this.m_aExtensions) {
            sMPExtensionsType.addSMPExtension(sMPExtension.getAsBDXR2Extension());
        }
        return sMPExtensionsType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SMPExtensionList sMPExtensionList = (SMPExtensionList)object;
        return this.m_aExtensions.equals(sMPExtensionList.m_aExtensions);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aExtensions).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Extensions", this.m_aExtensions).getToString();
    }

    @Nullable
    public static SMPExtensionList of(SMPExtension ... sMPExtensionArray) {
        SMPExtensionList sMPExtensionList = new SMPExtensionList();
        if (sMPExtensionArray != null) {
            for (SMPExtension sMPExtension : sMPExtensionArray) {
                if (sMPExtension == null) continue;
                sMPExtensionList.extensions().add((Object)sMPExtension);
            }
        }
        return sMPExtensionList.extensions().isEmpty() ? null : sMPExtensionList;
    }

    @Nullable
    public static SMPExtensionList ofString(@Nullable String string) {
        SMPExtensionList sMPExtensionList = new SMPExtensionList();
        sMPExtensionList.setExtensionAsString(string);
        return sMPExtensionList.extensions().isEmpty() ? null : sMPExtensionList;
    }

    @Nullable
    public static SMPExtensionList ofBDXR1(@Nullable List<com.helger.xsds.bdxr.smp1.ExtensionType> list) {
        if (list == null) {
            return null;
        }
        SMPExtensionList sMPExtensionList = new SMPExtensionList();
        for (com.helger.xsds.bdxr.smp1.ExtensionType extensionType : list) {
            SMPExtension sMPExtension = SMPExtension.ofBDXR1(extensionType);
            if (sMPExtension == null) continue;
            sMPExtensionList.extensions().add((Object)sMPExtension);
        }
        return sMPExtensionList.extensions().isEmpty() ? null : sMPExtensionList;
    }

    @Nullable
    public static SMPExtensionList ofBDXR2(@Nullable SMPExtensionsType sMPExtensionsType) {
        if (sMPExtensionsType == null) {
            return null;
        }
        SMPExtensionList sMPExtensionList = new SMPExtensionList();
        for (SMPExtensionType sMPExtensionType : sMPExtensionsType.getSMPExtension()) {
            SMPExtension sMPExtension = SMPExtension.ofBDXR2(sMPExtensionType);
            if (sMPExtension == null) continue;
            sMPExtensionList.extensions().add((Object)sMPExtension);
        }
        return sMPExtensionList.extensions().isEmpty() ? null : sMPExtensionList;
    }
}

