/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.httpclient;

import com.helger.commons.ValueEnforcer;
import com.helger.jaxb.GenericJAXBMarshaller;
import com.helger.smpclient.exception.SMPClientBadResponseException;
import com.helger.smpclient.httpclient.AbstractSMPResponseHandler;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hc.core5.http.HttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPHttpResponseHandlerUnsigned<T>
extends AbstractSMPResponseHandler<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMPHttpResponseHandlerUnsigned.class);
    private final GenericJAXBMarshaller<T> m_aMarshaller;

    public SMPHttpResponseHandlerUnsigned(@Nonnull GenericJAXBMarshaller<T> genericJAXBMarshaller) {
        this.m_aMarshaller = (GenericJAXBMarshaller)ValueEnforcer.notNull(genericJAXBMarshaller, (String)"Marshaller");
    }

    @Override
    @Nonnull
    public T handleEntity(@Nonnull HttpEntity httpEntity) throws SMPClientBadResponseException, IOException {
        Object object = this.m_aMarshaller.read(httpEntity.getContent());
        if (object == null) {
            throw new SMPClientBadResponseException("Malformed XML document returned from SMP server");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Successfully parsed unsigned SMP HTTP response");
        }
        return (T)object;
    }
}

