/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.peppol;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.datetime.PDTFactory;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.security.certificate.CertificateHelper;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.peppol.SMPClientReadOnly;
import com.helger.xsds.peppol.smp1.EndpointType;
import com.helger.xsds.peppol.smp1.SignedServiceMetadataType;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ISMPServiceMetadataProvider {
    @Nullable
    public SignedServiceMetadataType getServiceMetadataOrNull(@Nonnull IParticipantIdentifier var1, @Nonnull IDocumentTypeIdentifier var2) throws SMPClientException;

    @Nullable
    default public EndpointType getEndpoint(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) throws SMPClientException {
        return this.getEndpointAt(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, iSMPTransportProfile, PDTFactory.getCurrentLocalDateTime());
    }

    @Nullable
    default public EndpointType getEndpointAt(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile, @Nonnull LocalDateTime localDateTime) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ServiceGroupID");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocumentTypeID");
        ValueEnforcer.notNull((Object)iProcessIdentifier, (String)"ProcessID");
        ValueEnforcer.notNull((Object)iSMPTransportProfile, (String)"TransportProfile");
        ValueEnforcer.notNull((Object)localDateTime, (String)"CheckDT");
        SignedServiceMetadataType signedServiceMetadataType = this.getServiceMetadataOrNull(iParticipantIdentifier, iDocumentTypeIdentifier);
        return signedServiceMetadataType == null ? null : SMPClientReadOnly.getEndpointAt(signedServiceMetadataType, iProcessIdentifier, iSMPTransportProfile, localDateTime);
    }

    @Nullable
    default public String getEndpointAddress(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) throws SMPClientException {
        EndpointType endpointType = this.getEndpoint(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, iSMPTransportProfile);
        return SMPClientReadOnly.getEndpointAddress(endpointType);
    }

    @Nullable
    default public String getEndpointAddressAt(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile, @Nonnull LocalDateTime localDateTime) throws SMPClientException {
        EndpointType endpointType = this.getEndpointAt(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, iSMPTransportProfile, localDateTime);
        return SMPClientReadOnly.getEndpointAddress(endpointType);
    }

    @Nullable
    default public String getEndpointCertificateString(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) throws SMPClientException {
        EndpointType endpointType = this.getEndpoint(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, iSMPTransportProfile);
        return SMPClientReadOnly.getEndpointCertificateString(endpointType);
    }

    @Nullable
    default public String getEndpointCertificateStringAt(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile, @Nonnull LocalDateTime localDateTime) throws SMPClientException {
        EndpointType endpointType = this.getEndpointAt(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, iSMPTransportProfile, localDateTime);
        return SMPClientReadOnly.getEndpointCertificateString(endpointType);
    }

    @Nullable
    default public X509Certificate getEndpointCertificate(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) throws SMPClientException, CertificateException {
        String string = this.getEndpointCertificateString(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, iSMPTransportProfile);
        return CertificateHelper.convertStringToCertficate((String)string);
    }

    @Nullable
    default public X509Certificate getEndpointCertificateAt(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile, @Nonnull LocalDateTime localDateTime) throws SMPClientException, CertificateException {
        String string = this.getEndpointCertificateStringAt(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, iSMPTransportProfile, localDateTime);
        return CertificateHelper.convertStringToCertficate((String)string);
    }
}

