/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.url;

import com.helger.commons.ValueEnforcer;
import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.smpclient.url.SMPDNSResolutionException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ISMPURLProvider {
    @Nonnull
    public URI getSMPURIOfParticipant(@Nonnull IParticipantIdentifier var1, @Nullable String var2) throws SMPDNSResolutionException;

    @Nonnull
    default public URI getSMPURIOfParticipant(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull ISMLInfo iSMLInfo) throws SMPDNSResolutionException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantIdentifier");
        ValueEnforcer.notNull((Object)iSMLInfo, (String)"SMLInfo");
        return this.getSMPURIOfParticipant(iParticipantIdentifier, iSMLInfo.getDNSZone());
    }

    @Nonnull
    default public URL getSMPURLOfParticipant(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull ISMLInfo iSMLInfo) throws SMPDNSResolutionException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantIdentifier");
        ValueEnforcer.notNull((Object)iSMLInfo, (String)"SMLInfo");
        return this.getSMPURLOfParticipant(iParticipantIdentifier, iSMLInfo.getDNSZone());
    }

    @Nonnull
    default public URL getSMPURLOfParticipant(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nullable String string) throws SMPDNSResolutionException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantIdentifier");
        URI uRI = this.getSMPURIOfParticipant(iParticipantIdentifier, string);
        try {
            return uRI.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Error building SMP URL from URI: " + uRI, malformedURLException);
        }
    }
}

