/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.url;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.StringHelper;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.factory.PeppolIdentifierFactory;
import com.helger.security.messagedigest.EMessageDigestAlgorithm;
import com.helger.security.messagedigest.MessageDigestValue;
import com.helger.smpclient.url.IPeppolURLProvider;
import com.helger.smpclient.url.SMPDNSResolutionException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class PeppolURLProvider
implements IPeppolURLProvider {
    public static final PeppolURLProvider MUTABLE_INSTANCE = new PeppolURLProvider();
    public static final IPeppolURLProvider INSTANCE = MUTABLE_INSTANCE;
    public static final Charset URL_CHARSET = StandardCharsets.UTF_8;
    public static final Locale URL_LOCALE = Locale.US;
    private static final Logger LOGGER = LoggerFactory.getLogger(PeppolURLProvider.class);

    @Nonnull
    public static String getHashValueStringRepresentation(@Nonnull String string) {
        return MessageDigestValue.create((byte[])string.getBytes(URL_CHARSET), (EMessageDigestAlgorithm)EMessageDigestAlgorithm.MD5).getHexEncodedDigestString();
    }

    @Override
    @Nonnull
    public String getDNSNameOfParticipant(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nullable String string) throws SMPDNSResolutionException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantIdentifier");
        if (StringHelper.hasText((String)string) && !StringHelper.endsWith((CharSequence)string, (char)'.')) {
            throw new SMPDNSResolutionException("if an SML zone name is specified, it must end with a dot (.). Value is: " + string);
        }
        String string2 = StringHelper.getNotNull((String)iParticipantIdentifier.getScheme()).toLowerCase(URL_LOCALE);
        if (!PeppolIdentifierFactory.INSTANCE.isParticipantIdentifierSchemeValid(string2)) {
            LOGGER.warn("Invalid Peppol participant identifier scheme '" + string2 + "' used");
        }
        String string3 = StringHelper.getNotNull((String)iParticipantIdentifier.getValue());
        StringBuilder stringBuilder = new StringBuilder();
        if ("*".equals(string3)) {
            stringBuilder.append("*.");
        } else {
            stringBuilder.append("B-").append(PeppolURLProvider.getHashValueStringRepresentation(string3.toLowerCase(URL_LOCALE))).append('.');
        }
        if (!string2.isEmpty()) {
            stringBuilder.append(string2).append('.');
        }
        if (StringHelper.hasText((String)string)) {
            stringBuilder.append(string);
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }
}

