/*
 * Decompiled with CFR 0.152.
 */
package com.helger.holiday;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.locale.country.ECountry;
import com.helger.commons.string.StringHelper;
import com.helger.holiday.IHolidayManager;
import com.helger.holiday.mgr.XMLHolidayManager;
import com.helger.holiday.mgr.XMLHolidayManagerJapan;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;

public final class HolidayManagerFactory {
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static final ICommonsMap<String, Class<? extends IHolidayManager>> s_aClassMap = new CommonsHashMap();
    @GuardedBy(value="s_aRWLock")
    private static final ICommonsMap<String, IHolidayManager> s_aInstMap = new CommonsHashMap();
    private static final ICommonsSet<String> s_aSupportedCountries = new CommonsHashSet();

    private HolidayManagerFactory() {
    }

    public static void registerHolidayManagerClass(@Nonnull @Nonempty String string, @Nonnull Class<? extends IHolidayManager> clazz) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"CountryID");
        ValueEnforcer.notNull(clazz, (String)"Class");
        ValueEnforcer.isTrue((boolean)ClassHelper.isInstancableClass(clazz), (String)"The passed class must be public, not abstract and needs a no-argument ctor!");
        s_aRWLock.writeLocked(() -> {
            if (s_aClassMap.containsKey((Object)string)) {
                throw new IllegalArgumentException("A class for country " + string + " is already registered!");
            }
            s_aClassMap.put((Object)string, (Object)clazz);
        });
    }

    @Nonnull
    public static IHolidayManager getDefaultHolidayManager() {
        return HolidayManagerFactory.getHolidayManager(Locale.getDefault().getCountry());
    }

    @Nonnull
    public static IHolidayManager getHolidayManager(@Nonnull ECountry eCountry) {
        ValueEnforcer.notNull((Object)eCountry, (String)"Country");
        return HolidayManagerFactory.getHolidayManager(eCountry.getID());
    }

    @Nonnull
    public static IHolidayManager getHolidayManager(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"CountryID");
        IHolidayManager iHolidayManager = (IHolidayManager)s_aRWLock.readLocked(() -> (IHolidayManager)s_aInstMap.get((Object)string));
        if (iHolidayManager != null) {
            return iHolidayManager;
        }
        return (IHolidayManager)s_aRWLock.writeLocked(() -> (IHolidayManager)s_aInstMap.computeIfAbsent((Object)string, string2 -> {
            IHolidayManager iHolidayManager;
            Class clazz = (Class)s_aClassMap.get((Object)string);
            IHolidayManager iHolidayManager2 = iHolidayManager = clazz != null ? (IHolidayManager)GenericReflection.newInstance((Class)clazz) : new XMLHolidayManager(string);
            if (iHolidayManager == null) {
                throw new IllegalArgumentException("Failed to create holiday manager for country '" + string + "'");
            }
            return iHolidayManager;
        }));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getSupportedCountryCodes() {
        return (ICommonsSet)s_aSupportedCountries.getClone();
    }

    static {
        s_aSupportedCountries.addAll((Collection)StringHelper.getExploded((char)',', (String)"al,ar,at,au,ba,be,bg,bo,br,by,cr,ca,ch,cl,co,cz,de,dk,ec,ee,es,et,fi,fr,gr,hr,hu,ie,is,it,jp,kz,li,lt,lu,lv,md,me,mk,mt,mx,ng,nl,ni,no,pa,pe,pl,pt,py,ro,ru,rs,se,si,sk,ua,uk,us,uy,ve,za"));
        HolidayManagerFactory.registerHolidayManagerClass(XMLHolidayManagerJapan.COUNTRY_ID, XMLHolidayManagerJapan.class);
    }
}

