/*
 * Decompiled with CFR 0.152.
 */
package com.helger.holiday;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.holiday.ISingleHoliday;
import java.io.Serializable;
import java.time.LocalDate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HolidayMap
implements Serializable {
    private final ICommonsOrderedMap<LocalDate, ISingleHoliday> m_aMap = new CommonsLinkedHashMap();

    public boolean containsHolidayForDate(@Nullable LocalDate localDate) {
        return this.m_aMap.containsKey((Object)localDate);
    }

    @Nullable
    public ISingleHoliday getHolidayForDate(@Nullable LocalDate localDate) {
        return (ISingleHoliday)this.m_aMap.get((Object)localDate);
    }

    public void add(@Nonnull LocalDate localDate, @Nonnull ISingleHoliday iSingleHoliday) {
        ValueEnforcer.notNull((Object)localDate, (String)"Date");
        ValueEnforcer.notNull((Object)iSingleHoliday, (String)"Holiday");
        this.m_aMap.put((Object)localDate, (Object)iSingleHoliday);
    }

    public void addAll(@Nonnull HolidayMap holidayMap) {
        ValueEnforcer.notNull((Object)holidayMap, (String)"SubHolidays");
        this.m_aMap.putAll(holidayMap.m_aMap);
    }

    @Nonnull
    public EChange remove(@Nullable LocalDate localDate) {
        return this.m_aMap.removeObject((Object)localDate);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<LocalDate> getAllDates() {
        return this.m_aMap.copyOfKeySet();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ISingleHoliday> getAllHolidays() {
        return this.m_aMap.copyOfValues();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<LocalDate, ISingleHoliday> getMap() {
        return this.m_aMap.getClone();
    }

    @Nonnegative
    public int size() {
        return this.m_aMap.size();
    }

    public boolean isEmpty() {
        return this.m_aMap.isEmpty();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        HolidayMap holidayMap = (HolidayMap)object;
        return this.m_aMap.equals(holidayMap.m_aMap);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMap).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("map", this.m_aMap).getToString();
    }
}

