/*
 * Decompiled with CFR 0.152.
 */
package com.helger.holiday.mgr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.typeconvert.TypeConverter;
import com.helger.holiday.HolidayMap;
import com.helger.holiday.IHolidayManager;
import com.helger.holiday.ISingleHoliday;
import com.helger.holiday.mgr.CalendarHierarchy;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.extra.Interval;

public abstract class AbstractHolidayManager
implements IHolidayManager {
    private final ICommonsMap<String, HolidayMap> m_aHolidaysPerYear = new CommonsHashMap();

    protected AbstractHolidayManager() {
    }

    @Nonnull
    private static String _getKey(@Nonnull LocalDate localDate, String ... stringArray) {
        String string = Integer.toString(localDate.getYear());
        if (ArrayHelper.isNotEmpty((Object[])stringArray)) {
            StringBuilder stringBuilder = new StringBuilder(string);
            for (String string2 : stringArray) {
                stringBuilder.append('_').append(string2);
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    @Nullable
    public ISingleHoliday getHoliday(@Nonnull LocalDate localDate, String ... stringArray) {
        ValueEnforcer.notNull((Object)localDate, (String)"Date");
        String string = AbstractHolidayManager._getKey(localDate, stringArray);
        HolidayMap holidayMap = (HolidayMap)this.m_aHolidaysPerYear.get((Object)string);
        if (holidayMap == null) {
            holidayMap = this.getHolidays(localDate.getYear(), stringArray);
            this.m_aHolidaysPerYear.put((Object)string, (Object)holidayMap);
        }
        return holidayMap.getHolidayForDate(localDate);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public HolidayMap getHolidays(@Nonnull Interval interval, String ... stringArray) {
        ValueEnforcer.notNull((Object)interval, (String)"Interval");
        HolidayMap holidayMap = new HolidayMap();
        int n = ((LocalDate)TypeConverter.convert((Object)interval.getStart(), LocalDate.class)).getYear();
        int n2 = ((LocalDate)TypeConverter.convert((Object)interval.getEnd(), LocalDate.class)).getYear();
        for (int i = n; i <= n2; ++i) {
            HolidayMap holidayMap2 = this.getHolidays(i, stringArray);
            for (Map.Entry entry : holidayMap2.getMap().entrySet()) {
                if (!interval.contains((Instant)TypeConverter.convert(entry.getKey(), Instant.class))) continue;
                holidayMap.add((LocalDate)entry.getKey(), (ISingleHoliday)entry.getValue());
            }
        }
        return holidayMap;
    }

    @Nonnull
    public abstract CalendarHierarchy getHierarchy();
}

