/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.peppol.servlet;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.smpclient.peppol.ISMPServiceMetadataProvider;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Phase4PeppolReceiverCheckData {
    private final ISMPServiceMetadataProvider m_aSMPClient;
    private final String m_sAS4EndpointURL;
    private final X509Certificate m_aAPCertificate;

    public Phase4PeppolReceiverCheckData(@Nonnull ISMPServiceMetadataProvider iSMPServiceMetadataProvider, @Nonnull @Nonempty String string, @Nonnull X509Certificate x509Certificate) {
        ValueEnforcer.notNull((Object)iSMPServiceMetadataProvider, (String)"SMPClient");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"AS4EndpointURL");
        ValueEnforcer.notNull((Object)x509Certificate, (String)"APCertificate");
        this.m_aSMPClient = iSMPServiceMetadataProvider;
        this.m_sAS4EndpointURL = string;
        this.m_aAPCertificate = x509Certificate;
    }

    @Nonnull
    public ISMPServiceMetadataProvider getSMPClient() {
        return this.m_aSMPClient;
    }

    @Nonnull
    @Nonempty
    public String getAS4EndpointURL() {
        return this.m_sAS4EndpointURL;
    }

    @Nonnull
    public X509Certificate getAPCertificate() {
        return this.m_aAPCertificate;
    }
}

