/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.peppol.servlet;

import com.helger.commons.string.StringHelper;
import com.helger.phase4.peppol.servlet.Phase4PeppolReceiverCheckData;
import com.helger.smpclient.peppol.ISMPServiceMetadataProvider;
import java.security.cert.X509Certificate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class Phase4PeppolServletConfiguration {
    public static final boolean DEFAULT_RECEIVER_CHECK_ENABLED = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(Phase4PeppolServletConfiguration.class);
    private static boolean s_bReceiverCheckEnabled = true;
    private static ISMPServiceMetadataProvider s_aSMPClient;
    private static String s_sAS4EndpointURL;
    private static X509Certificate s_aAPCertificate;
    private static boolean s_bPerformSBDHValueChecks;

    private Phase4PeppolServletConfiguration() {
    }

    public static boolean isReceiverCheckEnabled() {
        return s_bReceiverCheckEnabled;
    }

    public static void setReceiverCheckEnabled(boolean bl) {
        s_bReceiverCheckEnabled = bl;
    }

    @Nullable
    public static ISMPServiceMetadataProvider getSMPClient() {
        return s_aSMPClient;
    }

    public static void setSMPClient(@Nullable ISMPServiceMetadataProvider iSMPServiceMetadataProvider) {
        s_aSMPClient = iSMPServiceMetadataProvider;
    }

    @Nullable
    public static String getAS4EndpointURL() {
        return s_sAS4EndpointURL;
    }

    public static void setAS4EndpointURL(@Nullable String string) {
        s_sAS4EndpointURL = string;
    }

    @Nullable
    public static X509Certificate getAPCertificate() {
        return s_aAPCertificate;
    }

    public static void setAPCertificate(@Nullable X509Certificate x509Certificate) {
        s_aAPCertificate = x509Certificate;
    }

    @Nullable
    public static Phase4PeppolReceiverCheckData getAsReceiverCheckData() {
        if (!Phase4PeppolServletConfiguration.isReceiverCheckEnabled()) {
            return null;
        }
        ISMPServiceMetadataProvider iSMPServiceMetadataProvider = Phase4PeppolServletConfiguration.getSMPClient();
        String string = Phase4PeppolServletConfiguration.getAS4EndpointURL();
        X509Certificate x509Certificate = Phase4PeppolServletConfiguration.getAPCertificate();
        if (iSMPServiceMetadataProvider == null || StringHelper.hasNoText((String)string) || x509Certificate == null) {
            return null;
        }
        return new Phase4PeppolReceiverCheckData(iSMPServiceMetadataProvider, string, x509Certificate);
    }

    public static boolean isPerformSBDHValueChecks() {
        return s_bPerformSBDHValueChecks;
    }

    public static void setPerformSBDHValueChecks(boolean bl) {
        boolean bl2 = bl != s_bPerformSBDHValueChecks;
        s_bPerformSBDHValueChecks = bl;
        if (bl2) {
            LOGGER.info("phase4 Peppol SBDH value checks are now " + (bl ? "enabled" : "disabled"));
        }
    }

    static {
        s_bPerformSBDHValueChecks = true;
    }
}

