/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.DBConnection;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.IRDBDriver;
import com.hp.hpl.jena.db.test.TestPackage;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.regression.TestCaseBasic;
import com.hp.hpl.jena.shared.JenaException;
import java.sql.SQLException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCompatability
extends TestCase {
    public TestCompatability(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static TestSuite suite() {
        ConfigTestCaseRDB config = new ConfigTestCaseRDB(TestPackage.M_DB_URL, TestPackage.M_DB_USER, TestPackage.M_DB_PASSWD, "Generic", TestPackage.M_DB);
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestCaseRDB("test0", config));
        suite.addTest((Test)new TestCaseRDB("test1", config));
        suite.addTest((Test)new TestCaseRDB("test2", config));
        suite.addTest((Test)new TestCaseRDB("test3", config));
        suite.addTest((Test)new TestCaseRDB("test4", config));
        suite.addTest((Test)new TestCaseRDB("test5", config));
        suite.addTest((Test)new TestCaseRDB("test6", config));
        suite.addTest((Test)new TestCaseRDB("test7", config));
        suite.addTest((Test)new TestCaseRDB("test8", config));
        suite.addTest((Test)new TestCaseRDB("test9", config));
        suite.addTest((Test)new TestCaseRDB("test10", config));
        suite.addTest((Test)new TestCaseRDB("test11", config));
        suite.addTest((Test)new TestCaseRDB("test12", config));
        suite.addTest((Test)new TestCaseRDB("test13", config));
        suite.addTest((Test)new TestCaseRDB("test14", config));
        suite.addTest((Test)new TestCaseRDB("test15", config));
        suite.addTest((Test)new TestCaseRDB("test16", config));
        suite.addTest((Test)new TestCaseRDB("test17", config));
        suite.addTest((Test)new TestCaseRDB("test18", config));
        suite.addTest((Test)new TestCaseRDB("test19", config));
        return suite;
    }

    protected static class TestCaseRDB
    extends TestCaseBasic {
        ConfigTestCaseRDB m_config;

        public TestCaseRDB(String name, ConfigTestCaseRDB config) {
            super(name);
            this.m_config = config;
        }

        public void setUp() {
            this.m1 = this.m_config.createModel("jr1");
            this.m2 = this.m_config.createModel("jr2");
            this.m3 = this.m_config.createModel("jr3");
            this.m4 = this.m_config.createModel("jr4");
        }

        public void tearDown() {
            if (this.m_config.supportsMultipleModels && !this.m_config.noReformat) {
                this.cleanModel((ModelRDB)this.m1);
                this.m2.close();
                this.m3.close();
                this.m4.close();
                try {
                    this.m_config.m_dbconn.close();
                }
                catch (SQLException e) {
                    System.out.println("Problem during db clean up in regression test");
                }
                this.m_config.m_dbconn = null;
            } else {
                this.cleanModel((ModelRDB)this.m1);
                this.cleanModel((ModelRDB)this.m2);
                this.cleanModel((ModelRDB)this.m3);
                this.cleanModel((ModelRDB)this.m4);
            }
        }

        private void cleanModel(ModelRDB m) {
            try {
                if (this.m_config.noReformat) {
                    StmtIterator i = m.listStatements();
                    while (i.hasNext()) {
                        i.next();
                        i.remove();
                    }
                } else {
                    m.getConnection().cleanDB();
                    m.close();
                }
            }
            catch (Exception e) {
                TestCaseRDB.assertTrue((String)("Problem clearning up regression databases: " + e), (boolean)false);
            }
        }
    }

    protected static class ConfigTestCaseRDB {
        String m_baseuri;
        String m_user;
        String m_password;
        String m_layout;
        String m_databaseType;
        boolean supportsMultipleModels;
        boolean supportsJenaReification;
        boolean noReformat;
        DBConnection m_dbconn = null;

        ConfigTestCaseRDB(String baseuri, String user, String password, String layout, String database) {
            this.m_baseuri = baseuri;
            this.m_user = user;
            this.m_password = password;
            this.m_layout = layout;
            this.m_databaseType = database;
            try {
                Class.forName(TestPackage.M_DBDRIVER_CLASS);
            }
            catch (Exception e) {
                throw new JenaException("Unable to instantiate  driver: " + TestPackage.M_DBDRIVER_CLASS);
            }
            try {
                DBConnection temp = new DBConnection(baseuri, user, password);
                IRDBDriver driver = temp.getDriver(layout, database);
                this.supportsMultipleModels = driver.supportsMultipleModels();
                this.supportsJenaReification = driver.supportsJenaReification();
            }
            catch (RDFRDBException e) {
                this.supportsMultipleModels = false;
            }
            this.noReformat = false;
        }

        ConfigTestCaseRDB(String baseuri, String user, String password, String layout, String database, boolean noReformat) {
            this(baseuri, user, password, layout, database);
            this.noReformat = noReformat;
        }

        ModelRDB createModel(String name) {
            if (this.supportsMultipleModels) {
                if (this.m_dbconn == null) {
                    this.m_dbconn = new DBConnection(this.m_baseuri, this.m_user, this.m_password, this.m_databaseType);
                    if (!this.m_dbconn.isFormatOK()) {
                        IRDBDriver driver = this.m_dbconn.getDriver(this.m_layout, this.m_databaseType);
                        driver.formatDB();
                    }
                }
                if (this.m_dbconn.containsModel(name)) {
                    ModelRDB.deleteModel((IDBConnection)this.m_dbconn, (String)name);
                }
                return ModelRDB.createModel((IDBConnection)this.m_dbconn, (String)name);
            }
            DBConnection dbcon = new DBConnection(this.m_baseuri + name, this.m_user, this.m_password);
            if (this.m_dbconn.containsDefaultModel()) {
                try {
                    this.m_dbconn.cleanDB();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ModelRDB.create((IDBConnection)dbcon, (String)this.m_layout, (String)this.m_databaseType);
        }
    }
}

