/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;

public class NodeCreateUtils {
    public static Node create(String x) {
        return NodeCreateUtils.create(PrefixMapping.Extended, x);
    }

    public static Node create(PrefixMapping pm, String x) {
        if (x.equals("")) {
            throw new JenaException("Node.create does not accept an empty string as argument");
        }
        char first = x.charAt(0);
        if (first == '\'' || first == '\"') {
            return Node.createLiteral((LiteralLabel)NodeCreateUtils.newString(pm, first, x));
        }
        if (Character.isDigit(first)) {
            return Node.createLiteral((String)x, (String)"", (RDFDatatype)XSDDatatype.XSDinteger);
        }
        if (first == '_') {
            return Node.createAnon((AnonId)new AnonId(x));
        }
        if (x.equals("??")) {
            return Node.ANY;
        }
        if (first == '?') {
            return Node.createVariable((String)x.substring(1));
        }
        if (first == '&') {
            return Node.createURI((String)("q:" + x.substring(1)));
        }
        int colon = x.indexOf(58);
        String d = pm.getNsPrefixURI("");
        return colon < 0 ? Node.createURI((String)((d == null ? "eh:/" : d) + x)) : Node.createURI((String)pm.expandPrefix(x));
    }

    public static String unEscape(String spelling) {
        int b;
        if (spelling.indexOf(92) < 0) {
            return spelling;
        }
        StringBuffer result = new StringBuffer(spelling.length());
        int start = 0;
        while ((b = spelling.indexOf(92, start)) >= 0) {
            result.append(spelling.substring(start, b));
            result.append(NodeCreateUtils.unEscape(spelling.charAt(b + 1)));
            start = b + 2;
        }
        result.append(spelling.substring(start));
        return result.toString();
    }

    public static char unEscape(char ch) {
        switch (ch) {
            case '\"': 
            case '\'': 
            case '\\': {
                return ch;
            }
            case 'n': {
                return '\n';
            }
            case 's': {
                return ' ';
            }
            case 't': {
                return '\t';
            }
        }
        return 'Z';
    }

    public static LiteralLabel literal(PrefixMapping pm, String spelling, String langOrType) {
        String content = NodeCreateUtils.unEscape(spelling);
        int colon = langOrType.indexOf(58);
        return colon < 0 ? new LiteralLabel(content, langOrType, false) : LiteralLabel.createLiteralLabel((String)content, (String)"", (RDFDatatype)Node.getType((String)pm.expandPrefix(langOrType)));
    }

    public static LiteralLabel newString(PrefixMapping pm, char quote, String nodeString) {
        int close = nodeString.lastIndexOf(quote);
        return NodeCreateUtils.literal(pm, nodeString.substring(1, close), nodeString.substring(close + 1));
    }
}

