/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.LPBackwardRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.rulesys.impl.BindingVector;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestBackchainer
extends TestCase {
    private static final int MAX_VARS = 10;
    protected Node p = Node.createURI((String)"p");
    protected Node q = Node.createURI((String)"q");
    protected Node r = Node.createURI((String)"r");
    protected Node s = Node.createURI((String)"s");
    protected Node t = Node.createURI((String)"t");
    protected Node a = Node.createURI((String)"a");
    protected Node b = Node.createURI((String)"b");
    protected Node c = Node.createURI((String)"c");
    protected Node d = Node.createURI((String)"d");
    protected Node C1 = Node.createURI((String)"C1");
    protected Node C2 = Node.createURI((String)"C2");
    protected Node C3 = Node.createURI((String)"C3");
    protected Node sP = RDFS.Nodes.subPropertyOf;
    protected Node sC = RDFS.Nodes.subClassOf;
    protected Node ty = RDF.Nodes.type;
    String testRules1 = "(?x ?q ?y) <- (?p rdfs:subPropertyOf ?q)(?x ?p ?y). (?a rdfs:subPropertyOf ?c) <- (?a rdfs:subPropertyOf ?b)(?b rdfs:subPropertyOf ?c). ";
    String testRuleAxioms = "[ -> (p rdfs:subPropertyOf q)][ -> (q rdfs:subPropertyOf r) ][ -> (a p b) ]";
    Triple[] dataElts = new Triple[]{new Triple(this.p, this.sP, this.q), new Triple(this.q, this.sP, this.r), new Triple(this.a, this.p, this.b)};

    public TestBackchainer(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestBackchainer.class);
    }

    public Reasoner createReasoner(List rules) {
        LPBackwardRuleReasoner reasoner = new LPBackwardRuleReasoner(rules);
        reasoner.tablePredicate(this.sP);
        reasoner.tablePredicate(this.sC);
        reasoner.tablePredicate(this.ty);
        reasoner.tablePredicate(this.p);
        reasoner.tablePredicate(this.a);
        reasoner.tablePredicate(this.b);
        return reasoner;
    }

    public void testParse() {
        List rules = Rule.parseRules((String)this.testRules1);
        TestBackchainer.assertEquals((String)"BRule parsing", (String)"[ (?x ?q ?y) <- (?p rdfs:subPropertyOf ?q) (?x ?p ?y) ]", (String)rules.get(0).toString());
        TestBackchainer.assertEquals((String)"BRule parsing", (String)"[ (?a rdfs:subPropertyOf ?c) <- (?a rdfs:subPropertyOf ?b) (?b rdfs:subPropertyOf ?c) ]", (String)rules.get(1).toString());
    }

    public void testUnify() {
        Node_RuleVariable xg = new Node_RuleVariable("?x", 0);
        Node_RuleVariable yg = new Node_RuleVariable("?y", 1);
        Node_RuleVariable zg = new Node_RuleVariable("?z", 2);
        Node_RuleVariable xh = new Node_RuleVariable("?x", 0);
        Node_RuleVariable yh = new Node_RuleVariable("?y", 1);
        Node_RuleVariable zh = new Node_RuleVariable("?z", 2);
        TriplePattern g1 = new TriplePattern((Node)xg, this.p, (Node)yg);
        TriplePattern g2 = new TriplePattern((Node)xg, this.p, (Node)xg);
        TriplePattern g3 = new TriplePattern(this.a, this.p, (Node)xg);
        TriplePattern g4 = new TriplePattern(this.a, this.p, this.b);
        TriplePattern h1 = new TriplePattern((Node)xh, this.p, (Node)yh);
        TriplePattern h2 = new TriplePattern((Node)xh, this.p, (Node)xh);
        TriplePattern h3 = new TriplePattern(this.a, this.p, (Node)xh);
        TriplePattern h4 = new TriplePattern(this.a, this.p, this.b);
        TriplePattern h5 = new TriplePattern((Node)xh, this.p, this.a);
        this.doTestUnify(g1, h1, true, new Node[]{null, null});
        this.doTestUnify(g1, h2, true, new Node[]{null, null});
        this.doTestUnify(g1, h3, true, new Node[]{null, null});
        this.doTestUnify(g1, h4, true, new Node[]{null, null});
        this.doTestUnify(g1, h5, true, new Node[]{null, null});
        this.doTestUnify(g2, h1, true, new Node[]{null, xh});
        this.doTestUnify(g2, h2, true, new Node[]{null, null});
        this.doTestUnify(g2, h3, true, new Node[]{this.a, null});
        this.doTestUnify(g2, h4, false, null);
        this.doTestUnify(g2, h5, true, new Node[]{this.a, null});
        this.doTestUnify(g3, h1, true, new Node[]{this.a, null});
        this.doTestUnify(g3, h2, true, new Node[]{this.a, null});
        this.doTestUnify(g3, h3, true, new Node[]{null, null});
        this.doTestUnify(g3, h4, true, new Node[]{null, null});
        this.doTestUnify(g3, h5, true, new Node[]{this.a, null});
        this.doTestUnify(g4, h1, true, new Node[]{this.a, this.b});
        this.doTestUnify(g4, h2, false, null);
        this.doTestUnify(g4, h3, true, new Node[]{this.b});
        this.doTestUnify(g4, h4, true, null);
        this.doTestUnify(g4, h5, false, null);
        this.doTestUnify(h1, h1, true, new Node[]{null, null});
        this.doTestUnify(new TriplePattern(null, null, null), h2, true, new Node[]{null, null});
        TriplePattern gf = new TriplePattern((Node)xg, this.p, Functor.makeFunctorNode((String)"f", (Node[])new Node[]{xg, this.b}));
        TriplePattern hf1 = new TriplePattern((Node)yh, this.p, Functor.makeFunctorNode((String)"f", (Node[])new Node[]{zh, this.b}));
        TriplePattern hf2 = new TriplePattern((Node)yh, this.p, Functor.makeFunctorNode((String)"f", (Node[])new Node[]{this.a, yh}));
        TriplePattern hf3 = new TriplePattern((Node)yh, this.p, Functor.makeFunctorNode((String)"f", (Node[])new Node[]{this.b, yh}));
        this.doTestUnify(gf, hf1, true, new Node[]{null, null, yh});
        this.doTestUnify(gf, hf2, false, null);
        this.doTestUnify(gf, hf3, true, new Node[]{null, this.b});
        BindingVector env = BindingVector.unify((TriplePattern)g2, (TriplePattern)h1, (int)10);
        env.bind((Node)xh, this.c);
        TestBackchainer.assertEquals((Object)env.getBinding((Node)yh), (Object)this.c);
        env = BindingVector.unify((TriplePattern)g2, (TriplePattern)h1, (int)10);
        env.bind((Node)yh, this.c);
        TestBackchainer.assertEquals((Object)env.getBinding((Node)xh), (Object)this.c);
    }

    private void doTestUnify(TriplePattern goal, TriplePattern head, boolean succeed, Node[] env) {
        BindingVector result = BindingVector.unify((TriplePattern)goal, (TriplePattern)head, (int)10);
        if (succeed) {
            TestBackchainer.assertNotNull((Object)result);
            if (env != null) {
                for (int i = 0; i < env.length; ++i) {
                    Node n = result.getEnvironment()[i];
                    if (env[i] != null) {
                        TestBackchainer.assertEquals((Object)env[i], (Object)n);
                        continue;
                    }
                    TestBackchainer.assertNull((Object)n);
                }
            }
        } else {
            TestBackchainer.assertNull((Object)result);
        }
    }

    public void testListData() {
        Graph data = Factory.createGraphMem();
        for (int i = 0; i < this.dataElts.length; ++i) {
            data.add(this.dataElts[i]);
        }
        Graph schema = Factory.createGraphMem();
        schema.add(new Triple(this.c, this.p, this.c));
        Reasoner reasoner = this.createReasoner(new ArrayList());
        InfGraph infgraph = reasoner.bindSchema(schema).bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(null, null, null), new Object[]{new Triple(this.p, this.sP, this.q), new Triple(this.q, this.sP, this.r), new Triple(this.a, this.p, this.b), new Triple(this.c, this.p, this.c)});
        List rules = Rule.parseRules((String)"-> (d p d).");
        reasoner = this.createReasoner(rules);
        infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(null, null, null), new Object[]{new Triple(this.p, this.sP, this.q), new Triple(this.q, this.sP, this.r), new Triple(this.a, this.p, this.b), new Triple(this.d, this.p, this.d)});
        infgraph = reasoner.bindSchema(schema).bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(null, null, null), new Object[]{new Triple(this.p, this.sP, this.q), new Triple(this.q, this.sP, this.r), new Triple(this.a, this.p, this.b), new Triple(this.c, this.p, this.c), new Triple(this.d, this.p, this.d)});
    }

    public void testBaseRules1() {
        List rules = Rule.parseRules((String)"[r1: (?a r ?c) <- (?a p ?b),(?b p ?c)]");
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.p, this.b));
        data.add(new Triple(this.b, this.p, this.c));
        data.add(new Triple(this.b, this.p, this.d));
        Reasoner reasoner = this.createReasoner(rules);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(null, this.r, null), new Object[]{new Triple(this.a, this.r, this.c), new Triple(this.a, this.r, this.d)});
    }

    public void testBaseRules2() {
        List rules = Rule.parseRules((String)"[r1: (?a r ?b) <- (?a p ?b)][r2: (?a r ?b) <- (?a q ?b)][r3: (?a r ?b) <- (?a s ?c), (?c s ?b)]");
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.p, this.b));
        data.add(new Triple(this.b, this.q, this.c));
        data.add(new Triple(this.a, this.s, this.b));
        data.add(new Triple(this.b, this.s, this.d));
        Reasoner reasoner = this.createReasoner(rules);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(null, this.r, null), new Object[]{new Triple(this.a, this.r, this.b), new Triple(this.b, this.r, this.c), new Triple(this.a, this.r, this.d)});
    }

    public void testBaseRules2b() {
        List rules = Rule.parseRules((String)"[r1: (?a r ?b) <- (?a p ?b)][r2: (?a r ?b) <- (?a q ?b)][r3: (?a r ?b) <- (?a t ?c), (?c t ?b)][r4: (?a t ?b) <- (?a s ?b)]");
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.p, this.b));
        data.add(new Triple(this.b, this.q, this.c));
        data.add(new Triple(this.a, this.s, this.b));
        data.add(new Triple(this.b, this.s, this.d));
        Reasoner reasoner = this.createReasoner(rules);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(null, this.r, null), new Object[]{new Triple(this.a, this.r, this.b), new Triple(this.b, this.r, this.c), new Triple(this.a, this.r, this.d)});
    }

    public void testBaseRules3() {
        List rules = Rule.parseRules((String)"[rule: (?a rdfs:subPropertyOf ?c) <- (?a rdfs:subPropertyOf ?b),(?b rdfs:subPropertyOf ?c)]");
        Reasoner reasoner = this.createReasoner(rules);
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.p, this.sP, this.q));
        data.add(new Triple(this.q, this.sP, this.r));
        data.add(new Triple(this.p, this.sP, this.s));
        data.add(new Triple(this.s, this.sP, this.t));
        data.add(new Triple(this.a, this.p, this.b));
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(null, RDFS.subPropertyOf.asNode(), null), new Object[]{new Triple(this.p, this.sP, this.q), new Triple(this.q, this.sP, this.r), new Triple(this.p, this.sP, this.s), new Triple(this.s, this.sP, this.t), new Triple(this.p, this.sP, this.t), new Triple(this.p, this.sP, this.r)});
    }

    public void testBaseRules3b() {
        List rules = Rule.parseRules((String)"[rule: (?a rdfs:subPropertyOf ?c) <- (?a rdfs:subPropertyOf ?b),(?b rdfs:subPropertyOf ?c)]");
        Reasoner reasoner = this.createReasoner(rules);
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.p, this.sP, this.q));
        data.add(new Triple(this.q, this.sP, this.r));
        data.add(new Triple(this.r, this.sP, this.t));
        data.add(new Triple(this.q, this.sP, this.s));
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(null, RDFS.subPropertyOf.asNode(), null), new Object[]{new Triple(this.p, this.sP, this.q), new Triple(this.q, this.sP, this.r), new Triple(this.r, this.sP, this.t), new Triple(this.q, this.sP, this.s), new Triple(this.p, this.sP, this.s), new Triple(this.p, this.sP, this.r), new Triple(this.p, this.sP, this.t), new Triple(this.q, this.sP, this.t), new Triple(this.p, this.sP, this.r)});
    }

    public void testBaseRules4() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.r, this.b));
        data.add(new Triple(this.b, this.r, this.c));
        data.add(new Triple(this.b, this.r, this.b));
        data.add(new Triple(this.b, this.r, this.d));
        List rules = Rule.parseRules((String)"[r1: (?x p ?y) <- (?x r ?y)][r2: (?x p ?z) <- (?x p ?y), (?y r ?z)]");
        Reasoner reasoner = this.createReasoner(rules);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.a, this.p, null), new Object[]{new Triple(this.a, this.p, this.b), new Triple(this.a, this.p, this.d), new Triple(this.a, this.p, this.c)});
    }

    public void testBaseRulesXSB1() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.p, this.c, this.q));
        data.add(new Triple(this.q, this.c, this.r));
        data.add(new Triple(this.p, this.d, this.q));
        data.add(new Triple(this.q, this.d, this.r));
        List rules = Rule.parseRules((String)"[r1: (?x a ?y) <- (?x c ?y)][r2: (?x a ?y) <- (?x b ?z), (?z c ?y)][r3: (?x b ?y) <- (?x d ?y)][r4: (?x b ?y) <- (?x a ?z), (?z d ?y)]");
        Reasoner reasoner = this.createReasoner(rules);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.p, this.a, null), new Object[]{new Triple(this.p, this.a, this.q), new Triple(this.p, this.a, this.r)});
    }

    public void testFunctors1() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.p, this.b));
        data.add(new Triple(this.a, this.q, this.c));
        List rules = Rule.parseRules((String)"[r1: (?x r f(?y,?z)) <- (?x p ?y), (?x q ?z)][r2: (?x s ?y) <- (?x r f(?y, ?z))]");
        Reasoner reasoner = this.createReasoner(rules);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.a, this.s, null), new Object[]{new Triple(this.a, this.s, this.b)});
    }

    public void testFunctors2() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.p, this.b));
        data.add(new Triple(this.a, this.q, this.c));
        data.add(new Triple(this.a, this.t, this.d));
        List rules = Rule.parseRules((String)"[r1: (?x r f(?y,?z)) <- (?x p ?y), (?x q ?z)][r2: (?x s ?y) <- (?x r f(?y, ?z))][r3: (?x r g(?y,?z)) <- (?x p ?y), (?x t ?z)][r4: (?x s ?z) <- (?x r g(?y, ?z))]");
        Reasoner reasoner = this.createReasoner(rules);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.a, this.s, null), new Object[]{new Triple(this.a, this.s, this.b), new Triple(this.a, this.s, this.d)});
    }

    public void testFunctors3() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.s, this.b));
        data.add(new Triple(this.a, this.t, this.c));
        List rules = Rule.parseRules((String)"[r1: (a q f(?x,?y)) <- (a s ?x), (a t ?y)][r2: (a p ?x) <- (a q ?x)][r3: (a r ?y) <- (a p f(?x, ?y))]");
        Reasoner reasoner = this.createReasoner(rules);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.a, this.r, null), new Object[]{new Triple(this.a, this.r, this.c)});
    }

    public void testBuiltin1() {
        Graph data = Factory.createGraphMem();
        List rules = Rule.parseRules((String)"[a1: -> (a p 2) ][a2: -> (a q 3) ][r1: (?x r ?s) <- (?x p ?y), (?x q ?z), sum(?y, ?z, ?s)]");
        Reasoner reasoner = this.createReasoner(rules);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.a, this.r, null), new Object[]{new Triple(this.a, this.r, Util.makeIntNode((int)5))});
    }

    public void testBuiltin2() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.p, this.b));
        data.add(new Triple(this.a, this.q, this.c));
        List rules = Rule.parseRules((String)"[r1: (?x r ?y ) <- bound(?x), (?x p ?y) ][r2: (?x r ?y) <- unbound(?x), (?x q ?y)]");
        Reasoner reasoner = this.createReasoner(rules);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.a, this.r, null), new Object[]{new Triple(this.a, this.r, this.b)});
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(null, this.r, null), new Object[]{new Triple(this.a, this.r, this.c)});
    }

    public void testBuiltin3() {
        Graph data = Factory.createGraphMem();
        List rules = Rule.parseRules((String)"[r1: (a p b ) <- unbound(?x) ]");
        Reasoner reasoner = this.createReasoner(rules);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.a, null, null), new Object[]{new Triple(this.a, this.p, this.b)});
    }

    public void testGroundHead() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.r, this.b));
        List rules = Rule.parseRules((String)"[r1: (a p b ) <- (a r b) ]");
        Reasoner reasoner = this.createReasoner(rules);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.a, null, null), new Object[]{new Triple(this.a, this.p, this.b), new Triple(this.a, this.r, this.b)});
    }

    public void testRebind() {
        List rules = Rule.parseRules((String)"[r1: (?a r ?c) <- (?a p ?b),(?b p ?c)]");
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.p, this.b));
        data.add(new Triple(this.b, this.p, this.c));
        data.add(new Triple(this.b, this.p, this.d));
        Reasoner reasoner = this.createReasoner(rules);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(null, this.r, null), new Object[]{new Triple(this.a, this.r, this.c), new Triple(this.a, this.r, this.d)});
        Graph ndata = Factory.createGraphMem();
        ndata.add(new Triple(this.a, this.p, this.d));
        ndata.add(new Triple(this.d, this.p, this.b));
        infgraph.rebind(ndata);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(null, this.r, null), new Object[]{new Triple(this.a, this.r, this.b)});
    }

    public void testRDFSProblemsb() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.C1, this.sC, this.C2));
        data.add(new Triple(this.C2, this.sC, this.C3));
        data.add(new Triple(this.C1, this.ty, RDFS.Class.asNode()));
        data.add(new Triple(this.C2, this.ty, RDFS.Class.asNode()));
        data.add(new Triple(this.C3, this.ty, RDFS.Class.asNode()));
        List rules = Rule.parseRules((String)"[rdfs8:  (?a rdfs:subClassOf ?b), (?b rdfs:subClassOf ?c) -> (?a rdfs:subClassOf ?c)][rdfs7:  (?a rdf:type rdfs:Class) -> (?a rdfs:subClassOf ?a)]");
        Reasoner reasoner = this.createReasoner(rules);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(null, this.sC, null), new Object[]{new Triple(this.C1, this.sC, this.C2), new Triple(this.C1, this.sC, this.C3), new Triple(this.C1, this.sC, this.C1), new Triple(this.C2, this.sC, this.C3), new Triple(this.C2, this.sC, this.C2), new Triple(this.C3, this.sC, this.C3)});
    }

    public void testRDFSProblems() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.p, this.sP, this.q));
        data.add(new Triple(this.q, this.sP, this.r));
        data.add(new Triple(this.C1, this.sC, this.C2));
        data.add(new Triple(this.C2, this.sC, this.C3));
        data.add(new Triple(this.a, this.ty, this.C1));
        List rules = Rule.parseRules((String)"[rdfs8:  (?a rdfs:subClassOf ?b), (?b rdfs:subClassOf ?c) -> (?a rdfs:subClassOf ?c)][rdfs9:  (?x rdfs:subClassOf ?y), (?a rdf:type ?x) -> (?a rdf:type ?y)][rdfs3:  (?x ?p ?y), (?p rdfs:range ?c) -> (?y rdf:type ?c)][rdfs7:  (?a rdf:type rdfs:Class) -> (?a rdfs:subClassOf ?a)]");
        Reasoner reasoner = this.createReasoner(rules);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.a, this.ty, null), new Object[]{new Triple(this.a, this.ty, this.C1), new Triple(this.a, this.ty, this.C2), new Triple(this.a, this.ty, this.C3)});
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.C1, this.sC, this.a), new Object[0]);
    }

    public void testHeadUnify() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.c, this.q, this.d));
        List rules = Rule.parseRules((String)"[r1: (c r ?x) <- (?x p f(?x b))][r2: (?y p f(a ?y)) <- (c q ?y)]");
        Reasoner reasoner = this.createReasoner(rules);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.c, this.r, null), new Object[0]);
        data.add(new Triple(this.c, this.q, this.a));
        rules = Rule.parseRules((String)"[r1: (c r ?x) <- (?x p f(?x a))][r2: (?y p f(a ?y)) <- (c q ?y)]");
        reasoner = this.createReasoner(rules);
        infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.c, this.r, null), new Object[]{new Triple(this.c, this.r, this.a)});
        data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.q, this.a));
        data.add(new Triple(this.a, this.q, this.b));
        data.add(new Triple(this.a, this.q, this.c));
        data.add(new Triple(this.b, this.q, this.d));
        data.add(new Triple(this.b, this.q, this.b));
        rules = Rule.parseRules((String)"[r1: (c r ?x) <- (?x p ?x)][r2: (?x p ?y) <- (a q ?x), (b q ?y)]");
        reasoner = this.createReasoner(rules);
        infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.c, this.r, null), new Object[]{new Triple(this.c, this.r, this.b)});
        rules = Rule.parseRules((String)"[r1: (c r ?x) <- (?x p ?x)][r2: (a p ?x) <- (a q ?x)]");
        reasoner = this.createReasoner(rules);
        infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.c, this.r, null), new Object[]{new Triple(this.c, this.r, this.a)});
    }

    public void testRestriction1() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.ty, this.r));
        data.add(new Triple(this.a, this.p, this.b));
        data.add(new Triple(this.r, this.sC, this.C1));
        data.add(new Triple(this.C1, OWL.onProperty.asNode(), this.p));
        data.add(new Triple(this.C1, OWL.allValuesFrom.asNode(), this.c));
        List rules = Rule.parseRules((String)"[rdfs9:  (?x rdfs:subClassOf ?y) (?a rdf:type ?x) -> (?a rdf:type ?y)][restriction2: (?C owl:onProperty ?P), (?C owl:allValuesFrom ?D) -> (?C owl:equivalentClass all(?P, ?D))][rs2: (?D owl:equivalentClass all(?P,?C)), (?X rdf:type ?D) -> (?X rdf:type all(?P,?C))][rp4: (?X rdf:type all(?P, ?C)), (?X ?P ?Y) -> (?Y rdf:type ?C)]");
        Reasoner reasoner = this.createReasoner(rules);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.b, this.ty, this.c), new Object[]{new Triple(this.b, this.ty, this.c)});
    }

    public void testRestriction2() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.ty, OWL.Thing.asNode()));
        data.add(new Triple(this.p, this.ty, OWL.FunctionalProperty.asNode()));
        data.add(new Triple(this.c, OWL.equivalentClass.asNode(), this.C1));
        data.add(new Triple(this.C1, this.ty, OWL.Restriction.asNode()));
        data.add(new Triple(this.C1, OWL.onProperty.asNode(), this.p));
        data.add(new Triple(this.C1, OWL.maxCardinality.asNode(), Util.makeIntNode((int)1)));
        List rules = Rule.parseRules((String)"[rdfs9:  bound(?y)   (?x rdfs:subClassOf ?y) (?a rdf:type ?x) -> (?a rdf:type ?y)][restriction4: (?C rdf:type owl:Restriction), (?C owl:onProperty ?P), (?C owl:maxCardinality ?X) -> (?C owl:equivalentClass max(?P, ?X))][restrictionProc11: (?P rdf:type owl:FunctionalProperty), (?X rdf:type owl:Thing) -> (?X rdf:type max(?P, 1))][equivalentClass1: (?P owl:equivalentClass ?Q) -> (?P rdfs:subClassOf ?Q) ][equivalentClass1: (?P owl:equivalentClass ?Q) -> (?Q rdfs:subClassOf ?P) ][restrictionSubclass1: bound(?D) (?D owl:equivalentClass ?R), isFunctor(?R) (?X rdf:type ?R)-> (?X rdf:type ?D)][rdfs8:  unbound(?c) (?a rdfs:subClassOf ?b) (?b rdfs:subClassOf ?c) -> (?a rdfs:subClassOf ?c)][rdfs8:  bound(?c)   (?b rdfs:subClassOf ?c) (?a rdfs:subClassOf ?b) -> (?a rdfs:subClassOf ?c)][rdfs9:  unbound(?y) (?a rdf:type ?x) (?x rdfs:subClassOf ?y) -> (?a rdf:type ?y)][-> (rdf:type      rdfs:range rdfs:Class)][rdfs3:  bound(?c)   (?p rdfs:range ?c) (?x ?p ?y) -> (?y rdf:type ?c)][rdfs7:  (?a rdf:type rdfs:Class) -> (?a rdfs:subClassOf ?a)][restrictionProc13: (owl:Thing rdfs:subClassOf all(?P, ?C)) -> (?P rdfs:range ?C)][restrictionSubclass1: unbound(?D) (?X rdf:type ?R), isFunctor(?R) (?D owl:equivalentClass ?R) -> (?X rdf:type ?D)][restrictionSubclass2: bound(?R), isFunctor(?R), (?D owl:equivalentClass ?R),(?X rdf:type ?D) -> (?X rdf:type ?R)][restrictionSubclass2: unbound(?R), (?X rdf:type ?D), (?D owl:equivalentClass ?R) isFunctor(?R) -> (?X rdf:type ?R)]");
        Reasoner reasoner = this.createReasoner(rules);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.a, this.ty, this.C1), new Object[]{new Triple(this.a, this.ty, this.C1)});
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.a, this.ty, this.c), new Object[]{new Triple(this.a, this.ty, this.c)});
    }

    public void testRestriction3() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.ty, this.r));
        data.add(new Triple(this.r, this.sC, this.C1));
        data.add(new Triple(this.C1, this.ty, OWL.Restriction.asNode()));
        data.add(new Triple(this.C1, OWL.onProperty.asNode(), this.p));
        data.add(new Triple(this.C1, OWL.allValuesFrom.asNode(), this.c));
        List rules = Rule.parseRules((String)"[-> (rdfs:subClassOf rdfs:range rdfs:Class)][rdfs3:  bound(?c)   (?p rdfs:range ?c) (?x ?p ?y) -> (?y rdf:type ?c)][rdfs3:  unbound(?c) (?x ?p ?y), (?p rdfs:range ?c) -> (?y rdf:type ?c)][rdfs7:  (?a rdf:type rdfs:Class) -> (?a rdfs:subClassOf ?a)][rdfs8:  (?a rdfs:subClassOf ?b) (?b rdfs:subClassOf ?c) -> (?a rdfs:subClassOf ?c)][restrictionProc4b: bound(?Y) (?X ?P ?Y), notEqual(?P, rdf:type), (?X rdf:type all(?P, ?C)),-> (?Y rdf:type ?C)][restrictionProc4b: unbound(?Y), (?X rdf:type all(?P, ?C)), (?X ?P ?Y), notEqual(?P, rdf:type),-> (?Y rdf:type ?C)]");
        Reasoner reasoner = this.createReasoner(rules);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(null, this.ty, this.c), new Object[0]);
    }

    public void testClose() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.p, this.sP, this.q));
        data.add(new Triple(this.q, this.sP, this.r));
        data.add(new Triple(this.C1, this.sC, this.C2));
        data.add(new Triple(this.C2, this.sC, this.C3));
        data.add(new Triple(this.a, this.ty, this.C1));
        data.add(new Triple(this.ty, RDFS.range.asNode(), RDFS.Class.asNode()));
        List rules = Rule.parseRules((String)"[rdfs8:  (?a rdfs:subClassOf ?b), (?b rdfs:subClassOf ?c) -> (?a rdfs:subClassOf ?c)][rdfs9:  (?x rdfs:subClassOf ?y), (?a rdf:type ?x) -> (?a rdf:type ?y)][rdfs3:  (?x ?p ?y), (?p rdfs:range ?c) -> (?y rdf:type ?c)][rdfs7:  (?a rdf:type rdfs:Class) -> (?a rdfs:subClassOf ?a)]");
        Reasoner reasoner = this.createReasoner(rules);
        InfGraph infgraph = reasoner.bind(data);
        ExtendedIterator it = infgraph.find(this.a, this.ty, null);
        Triple result = (Triple)it.next();
        TestBackchainer.assertEquals((Object)result.getSubject(), (Object)this.a);
        TestBackchainer.assertEquals((Object)result.getPredicate(), (Object)this.ty);
        it.close();
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.a, this.ty, null), new Object[]{new Triple(this.a, this.ty, this.C1), new Triple(this.a, this.ty, this.C2), new Triple(this.a, this.ty, this.C3)});
    }

    public void testBug1() throws IOException {
        Graph data = Factory.createGraphMem();
        Node p = Node.createURI((String)"http://www.hpl.hp.com/semweb/2003/eg#p");
        Node r = Node.createURI((String)"http://www.hpl.hp.com/semweb/2003/eg#r");
        Node C1 = Node.createURI((String)"http://www.hpl.hp.com/semweb/2003/eg#C1");
        data.add(new Triple(this.a, p, this.b));
        List rules = Rule.parseRules((Rule.Parser)Util.loadRuleParserFromResourceFile((String)"testing/reasoners/bugs/rdfs-error1.brules"));
        Reasoner reasoner = this.createReasoner(rules);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.b, this.ty, C1), new Object[]{new Triple(this.b, this.ty, C1)});
    }
}

