/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.signatures.validation.lotl.IOnFailingCountryLotlData;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.LongUnaryOperator;

public class LotlFetchingProperties {
    private final IOnFailingCountryLotlData onCountryFetchFailureStrategy;
    private Set<String> ignoredSchemaNames = new HashSet<String>();
    private HashSet<String> serviceTypes = new HashSet();
    private HashSet<String> schemaNames = new HashSet();
    private long staleNessInMillis = 86400000L;
    private LongUnaryOperator refreshIntervalCalculator = stalenessTime -> {
        if (stalenessTime <= 0L) {
            throw new PdfException("Staleness must be a positive value. It is used to determine how long the cache is valid before it needs to be refreshed.");
        }
        double PERCENTAGE = 0.23;
        return (long)((double)stalenessTime * 0.23);
    };

    public LotlFetchingProperties(IOnFailingCountryLotlData countryFetchFailureStrategy) {
        this.onCountryFetchFailureStrategy = countryFetchFailureStrategy;
    }

    public LotlFetchingProperties setCountryNames(String ... countryNames) {
        if (!this.ignoredSchemaNames.isEmpty()) {
            throw new IllegalArgumentException("You cannot use both 'addSchemaName' and 'addSchemaNameToIgnore' methods. either provide specific countries to process, or provide specific countries to ignore (All countries not ignored will be processed). ");
        }
        this.schemaNames = new HashSet<String>(Arrays.asList(countryNames));
        return this;
    }

    public LotlFetchingProperties setCountryNamesToIgnore(String ... countryNamesToIgnore) {
        if (!this.schemaNames.isEmpty()) {
            throw new IllegalArgumentException("You cannot use both 'addSchemaName' and 'addSchemaNameToIgnore' methods. either provide specific countries to process, or provide specific countries to ignore (All countries not ignored will be processed). ");
        }
        this.ignoredSchemaNames = new HashSet<String>(Arrays.asList(countryNamesToIgnore));
        return this;
    }

    public long getCacheStalenessInMilliseconds() {
        return this.staleNessInMillis;
    }

    public LotlFetchingProperties setCacheStalenessInMilliseconds(long stalenessInMillis) {
        if (stalenessInMillis <= 0L) {
            throw new PdfException("Staleness must be a positive value. It is used to determine how long the cache is valid before it needs to be refreshed.");
        }
        this.staleNessInMillis = stalenessInMillis;
        return this;
    }

    public LongUnaryOperator getRefreshIntervalCalculator() {
        return this.refreshIntervalCalculator;
    }

    public LotlFetchingProperties setRefreshIntervalCalculator(LongUnaryOperator refreshIntervalCalculator) {
        this.refreshIntervalCalculator = refreshIntervalCalculator;
        return this;
    }

    public IOnFailingCountryLotlData getOnCountryFetchFailureStrategy() {
        return this.onCountryFetchFailureStrategy;
    }

    public LotlFetchingProperties setServiceTypes(String ... serviceType) {
        this.serviceTypes = new HashSet<String>(Arrays.asList(serviceType));
        return this;
    }

    Set<String> getServiceTypes() {
        return Collections.unmodifiableSet(this.serviceTypes);
    }

    boolean shouldProcessCountry(String countryName) {
        if (!this.schemaNames.isEmpty() && !this.ignoredSchemaNames.isEmpty()) {
            throw new IllegalStateException("You cannot use both 'addSchemaName' and 'addSchemaNameToIgnore' methods. either provide specific countries to process, or provide specific countries to ignore (All countries not ignored will be processed). ");
        }
        if (this.schemaNames.isEmpty() && this.ignoredSchemaNames.isEmpty()) {
            return true;
        }
        if (!this.ignoredSchemaNames.isEmpty()) {
            return !this.ignoredSchemaNames.contains(countryName);
        }
        return this.schemaNames.contains(countryName);
    }
}

