/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.utils.DrawUtils;

public class EllipseSvgNodeRenderer
extends AbstractSvgNodeRenderer {
    float cx;
    float cy;
    float rx;
    float ry;

    @Override
    protected void doDraw(SvgDrawContext context) {
        PdfCanvas cv = context.getCurrentCanvas();
        cv.writeLiteral("% ellipse\n");
        if (this.setParameters(context)) {
            double[] startPoint = new double[]{(double)this.cx + (double)this.rx, this.cy};
            AffineTransform transform = this.applyNonScalingStrokeTransform(context);
            if (transform != null) {
                transform.transform(startPoint, 0, startPoint, 0, startPoint.length / 2);
            }
            cv.moveTo(startPoint[0], startPoint[1]);
            DrawUtils.arc((double)this.cx - (double)this.rx, (double)this.cy - (double)this.ry, (double)this.cx + (double)this.rx, (double)this.cy + (double)this.ry, 0.0, 360.0, cv, transform);
        }
    }

    @Override
    public Rectangle getObjectBoundingBox(SvgDrawContext context) {
        if (this.setParameters(context)) {
            return new Rectangle(this.cx - this.rx, this.cy - this.ry, this.rx + this.rx, this.ry + this.ry);
        }
        return null;
    }

    @Deprecated
    protected boolean setParameters() {
        return this.setParameters(new SvgDrawContext(null, null));
    }

    protected boolean setParameters(SvgDrawContext context) {
        this.initCenter(context);
        String rxValue = this.getAttribute("rx");
        String ryValue = this.getAttribute("ry");
        this.rx = this.parseHorizontalLength(rxValue, context);
        this.ry = this.parseVerticalLength(ryValue, context);
        if (rxValue == null) {
            this.rx = this.ry;
        }
        if (ryValue == null) {
            this.ry = this.rx;
        }
        return this.rx > 0.0f && this.ry > 0.0f;
    }

    protected void initCenter(SvgDrawContext context) {
        this.cx = 0.0f;
        this.cy = 0.0f;
        if (this.getAttribute("cx") != null) {
            this.cx = this.parseHorizontalLength(this.getAttribute("cx"), context);
        }
        if (this.getAttribute("cy") != null) {
            this.cy = this.parseVerticalLength(this.getAttribute("cy"), context);
        }
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        EllipseSvgNodeRenderer copy = new EllipseSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }

    @Override
    void doStrokeOrFill(String fillRuleRawValue, PdfCanvas currentCanvas) {
        DrawUtils.doStrokeOrFillForClosedFigure(fillRuleRawValue, currentCanvas, this.doStroke);
    }
}

