/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.integration.extendedattributes;

import com.ithit.webdav.integration.extendedattributes.ExtendedAttribute;
import com.ithit.webdav.integration.extendedattributes.ExtendedAttributeFactory;
import com.ithit.webdav.server.exceptions.ServerException;
import java.io.IOException;

public final class ExtendedAttributesExtension {
    private ExtendedAttributesExtension() {
    }

    public static String getExtendedAttribute(String path, String attribName) throws ServerException {
        try {
            return ExtendedAttributesExtension.getExtendedAttributeSupport().getExtendedAttribute(path, attribName);
        }
        catch (IOException e) {
            throw new ServerException(e.getMessage());
        }
    }

    public static void setExtendedAttribute(String path, String attribName, String attribValue) throws ServerException {
        try {
            ExtendedAttributesExtension.getExtendedAttributeSupport().setExtendedAttribute(path, attribName, attribValue);
        }
        catch (IOException e) {
            throw new ServerException(e.getMessage());
        }
    }

    public static boolean hasExtendedAttribute(String path, String attribName) throws ServerException {
        try {
            return ExtendedAttributesExtension.getExtendedAttributeSupport().getExtendedAttribute(path, attribName) != null;
        }
        catch (IOException e) {
            throw new ServerException(e.getMessage());
        }
    }

    public static void deleteExtendedAttribute(String path, String attribName) throws ServerException {
        try {
            ExtendedAttributesExtension.getExtendedAttributeSupport().deleteExtendedAttribute(path, attribName);
        }
        catch (IOException e) {
            throw new ServerException(e.getMessage());
        }
    }

    public static boolean isExtendedAttributesSupported(String path) {
        return ExtendedAttributesExtension.getExtendedAttributeSupport().isExtendedAttributeSupported(path);
    }

    private static ExtendedAttribute getExtendedAttributeSupport() {
        return ExtendedAttributeFactory.buildFileExtendedAttributeSupport();
    }
}

