/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.integration.servlet.websocket;

import com.ithit.webdav.integration.servlet.websocket.DavWebSocketNotification;
import com.ithit.webdav.integration.servlet.websocket.MovedDavWebSocketNotification;
import com.ithit.webdav.server.util.StringUtil;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Session;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class DavWebSocketEndpoint
extends Endpoint {
    private static final Map<String, WebSocketClient> SESSIONS = new HashMap<String, WebSocketClient>();
    private static DavWebSocketEndpoint instance;

    public static DavWebSocketEndpoint getInstance() {
        return instance;
    }

    private static void setInstance(DavWebSocketEndpoint instance) {
        DavWebSocketEndpoint.instance = instance;
    }

    public void onClose(Session session, CloseReason closeReason) {
        SESSIONS.remove(session.getId());
        DavWebSocketEndpoint.setInstance(this);
    }

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        SESSIONS.put(session.getId(), new WebSocketClient((String)endpointConfig.getUserProperties().get("InstanceId"), session));
        DavWebSocketEndpoint.setInstance(this);
    }

    private void send(String itemPath, String operation, String clientId) {
        itemPath = StringUtil.trimEnd((String)StringUtil.trimStart((String)itemPath, (String)"/"), (String)"/");
        DavWebSocketNotification notification = new DavWebSocketNotification(itemPath, operation);
        for (WebSocketClient s : StringUtil.isNullOrEmpty((String)clientId) ? SESSIONS.values() : (Collection)SESSIONS.values().stream().filter(webSocketClient -> !webSocketClient.instanceId.equals(clientId)).collect(Collectors.toSet())) {
            if (!s.session.isOpen()) continue;
            s.session.getAsyncRemote().sendObject((Object)notification);
        }
    }

    public void notifyCreated(String itemPath, String clientId) {
        this.send(itemPath, "created", clientId);
    }

    public void notifyUpdated(String itemPath, String clientId) {
        this.send(itemPath, "updated", clientId);
    }

    public void notifyDeleted(String itemPath, String clientId) {
        this.send(itemPath, "deleted", clientId);
    }

    public void notifyLocked(String itemPath, String clientId) {
        this.send(itemPath, "locked", clientId);
    }

    public void notifyUnlocked(String itemPath, String clientId) {
        this.send(itemPath, "unlocked", clientId);
    }

    public void notifyMoved(String itemPath, String targetPath, String clientId) {
        itemPath = StringUtil.trimEnd((String)StringUtil.trimStart((String)itemPath, (String)"/"), (String)"/");
        targetPath = StringUtil.trimEnd((String)StringUtil.trimStart((String)targetPath, (String)"/"), (String)"/");
        MovedDavWebSocketNotification movedNotification = new MovedDavWebSocketNotification(itemPath, "moved", targetPath);
        for (WebSocketClient s : clientId != null ? (Collection)SESSIONS.values().stream().filter(webSocketClient -> !webSocketClient.instanceId.equals(clientId)).collect(Collectors.toSet()) : SESSIONS.values()) {
            if (!s.session.isOpen()) continue;
            s.session.getAsyncRemote().sendObject((Object)movedNotification);
        }
    }

    private static class WebSocketClient {
        private final String instanceId;
        private final Session session;

        public WebSocketClient(String instanceId, Session session) {
            this.instanceId = instanceId;
            this.session = session;
        }
    }
}

