/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.integration.spring.websocket;

import com.ithit.webdav.integration.servlet.websocket.DavWebSocketNotification;
import com.ithit.webdav.integration.servlet.websocket.MovedDavWebSocketNotification;
import com.ithit.webdav.server.util.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class WebSocketServer {
    private final List<WebSocketSession> sessions;

    public WebSocketServer(List<WebSocketSession> sessions) {
        this.sessions = sessions;
    }

    private void send(String itemPath, String operation, String clientId) {
        itemPath = StringUtil.trimEnd((String)StringUtil.trimStart((String)itemPath, (String)"/"), (String)"/");
        TextMessage textMessage = new TextMessage((CharSequence)new DavWebSocketNotification(itemPath, operation).toString());
        this.send(clientId, textMessage);
    }

    public void notifyCreated(String itemPath, String clientId) {
        this.send(itemPath, "created", clientId);
    }

    public void notifyUpdated(String itemPath, String clientId) {
        this.send(itemPath, "updated", clientId);
    }

    public void notifyDeleted(String itemPath, String clientId) {
        this.send(itemPath, "deleted", clientId);
    }

    public void notifyLocked(String itemPath, String clientId) {
        this.send(itemPath, "locked", clientId);
    }

    public void notifyUnlocked(String itemPath, String clientId) {
        this.send(itemPath, "unlocked", clientId);
    }

    public void notifyMoved(String itemPath, String targetPath, String clientId) {
        itemPath = StringUtil.trimEnd((String)StringUtil.trimStart((String)itemPath, (String)"/"), (String)"/");
        targetPath = StringUtil.trimEnd((String)StringUtil.trimStart((String)targetPath, (String)"/"), (String)"/");
        TextMessage textMessage = new TextMessage((CharSequence)new MovedDavWebSocketNotification(itemPath, "moved", targetPath).toString());
        this.send(clientId, textMessage);
    }

    private void send(String clientId, TextMessage textMessage) {
        for (WebSocketSession webSocketSession : StringUtil.isNullOrEmpty((String)clientId) ? this.sessions : (Collection)this.sessions.stream().filter(x -> !x.getAttributes().get("InstanceId").equals(clientId)).collect(Collectors.toSet())) {
            try {
                webSocketSession.sendMessage((WebSocketMessage)textMessage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

