/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.ReadContext;
import com.jayway.jsonpath.internal.JsonReader;
import com.jayway.jsonpath.internal.PathToken;
import com.jayway.jsonpath.internal.PathTokenizer;
import com.jayway.jsonpath.internal.Utils;
import com.jayway.jsonpath.internal.filter.PathTokenFilter;
import com.jayway.jsonpath.spi.HttpProviderFactory;
import com.jayway.jsonpath.spi.JsonProvider;
import com.jayway.jsonpath.spi.JsonProviderFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPath {
    private static final Logger LOG = LoggerFactory.getLogger((String)JsonPath.class.getName());
    private static Pattern DEFINITE_PATH_PATTERN = Pattern.compile(".*(\\.\\.|\\*|\\[[\\\\/]|\\?|,|:\\s?]|\\[\\s?:|>|\\(|<|=|\\+).*");
    private PathTokenizer tokenizer;
    private LinkedList<Filter> filters;

    private JsonPath(String jsonPath, Filter[] filters) {
        Utils.notNull(jsonPath, "path can not be null", new Object[0]);
        jsonPath = jsonPath.trim();
        Utils.notEmpty(jsonPath, "path can not be empty", new Object[0]);
        int filterCountInPath = Utils.countMatches(jsonPath, "[?]");
        Utils.isTrue(filterCountInPath == filters.length, "Filters in path ([?]) does not match provided filters.");
        this.tokenizer = new PathTokenizer(jsonPath);
        if (LOG.isDebugEnabled()) {
            LOG.debug("New JsonPath:\n{}", (Object)this.tokenizer.toString());
        }
        this.filters = new LinkedList();
        this.filters.addAll(Arrays.asList(filters));
    }

    PathTokenizer getTokenizer() {
        return this.tokenizer;
    }

    public JsonPath copy() {
        Filter[] filterCopy = this.filters.isEmpty() ? new Filter[]{} : new Filter[this.filters.size()];
        return new JsonPath(this.tokenizer.getPath(), this.filters.toArray(filterCopy));
    }

    public String getPath() {
        return this.tokenizer.getPath();
    }

    public static boolean isPathDefinite(String path) {
        String preparedPath = path.replaceAll("\"[^\"\\\\\\n\r]*\"", "");
        return !DEFINITE_PATH_PATTERN.matcher(preparedPath).matches();
    }

    public boolean isPathDefinite() {
        return JsonPath.isPathDefinite(this.getPath());
    }

    public <T> T read(Object jsonObject) {
        return this.read(jsonObject, Configuration.defaultConfiguration());
    }

    public <T> T read(Object jsonObject, Configuration configuration) {
        Utils.notNull(jsonObject, "json can not be null", new Object[0]);
        Utils.notNull(configuration, "configuration can not be null", new Object[0]);
        if (this.getPath().equals("$")) {
            return (T)jsonObject;
        }
        if (!configuration.getProvider().isContainer(jsonObject)) {
            throw new IllegalArgumentException("Invalid container object");
        }
        LinkedList<Filter> contextFilters = new LinkedList<Filter>(this.filters);
        Object result = jsonObject;
        boolean inArrayContext = false;
        for (PathToken pathToken : this.tokenizer) {
            PathTokenFilter filter = pathToken.getFilter();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Applying filter: " + filter + " to " + result);
            }
            if ((result = filter.filter(result, configuration, contextFilters, inArrayContext)) == null && !pathToken.isEndToken()) {
                throw new PathNotFoundException("Path token: '" + pathToken.getFragment() + "' not found.");
            }
            if (inArrayContext) continue;
            inArrayContext = filter.isArrayFilter();
        }
        return (T)result;
    }

    public <T> T read(String json) {
        return this.read(json, Configuration.defaultConfiguration());
    }

    public <T> T read(String json, Configuration configuration) {
        Utils.notEmpty(json, "json can not be null or empty", new Object[0]);
        Utils.notNull(configuration, "jsonProvider can not be null", new Object[0]);
        return this.read(configuration.getProvider().parse(json), configuration);
    }

    public <T> T read(URL jsonURL) throws IOException {
        return this.read(jsonURL, Configuration.defaultConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T read(URL jsonURL, Configuration configuration) throws IOException {
        Utils.notNull(jsonURL, "json URL can not be null", new Object[0]);
        Utils.notNull(configuration, "jsonProvider can not be null", new Object[0]);
        InputStream in = null;
        try {
            in = HttpProviderFactory.getProvider().get(jsonURL);
            T t = this.read(configuration.getProvider().parse(in), configuration);
            return t;
        }
        finally {
            Utils.closeQuietly(in);
        }
    }

    public <T> T read(File jsonFile) throws IOException {
        return this.read(jsonFile, Configuration.defaultConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T read(File jsonFile, Configuration configuration) throws IOException {
        T t;
        Utils.notNull(jsonFile, "json file can not be null", new Object[0]);
        Utils.isTrue(jsonFile.exists(), "json file does not exist");
        Utils.notNull(configuration, "jsonProvider can not be null", new Object[0]);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(jsonFile);
            t = this.read(configuration.getProvider().parse(fis), configuration);
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(fis);
            throw throwable;
        }
        Utils.closeQuietly(fis);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T read(InputStream jsonInputStream) throws IOException {
        Utils.notNull(jsonInputStream, "json input stream can not be null", new Object[0]);
        try {
            T t = this.read(JsonProviderFactory.createProvider().parse(jsonInputStream));
            return t;
        }
        finally {
            Utils.closeQuietly(jsonInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T read(InputStream jsonInputStream, Configuration configuration) throws IOException {
        Utils.notNull(jsonInputStream, "json input stream can not be null", new Object[0]);
        Utils.notNull(configuration, "configuration can not be null", new Object[0]);
        try {
            T t = this.read(configuration.getProvider().parse(jsonInputStream), configuration);
            return t;
        }
        finally {
            Utils.closeQuietly(jsonInputStream);
        }
    }

    public static JsonPath compile(String jsonPath, Filter ... filters) {
        Utils.notEmpty(jsonPath, "json can not be null or empty", new Object[0]);
        return new JsonPath(jsonPath, filters);
    }

    public static <T> T read(Object json, String jsonPath, Filter ... filters) {
        return JsonPath.compile(jsonPath, filters).read(json);
    }

    public static <T> T read(String json, String jsonPath, Filter ... filters) {
        return new JsonReader().parse(json).read(jsonPath, filters);
    }

    public static <T> T read(URL jsonURL, String jsonPath, Filter ... filters) throws IOException {
        return new JsonReader().parse(jsonURL).read(jsonPath, filters);
    }

    public static <T> T read(File jsonFile, String jsonPath, Filter ... filters) throws IOException {
        return new JsonReader().parse(jsonFile).read(jsonPath, filters);
    }

    public static <T> T read(InputStream jsonInputStream, String jsonPath, Filter ... filters) throws IOException {
        return new JsonReader().parse(jsonInputStream).read(jsonPath, filters);
    }

    public static ParseContext using(Configuration configuration) {
        return new JsonReader(configuration);
    }

    public static ParseContext using(JsonProvider provider) {
        return new JsonReader(Configuration.builder().jsonProvider(provider).build());
    }

    public static ReadContext parse(Object json) {
        return new JsonReader().parse(json);
    }

    public static ReadContext parse(String json) {
        return new JsonReader().parse(json);
    }

    public static ReadContext parse(InputStream json) {
        return new JsonReader().parse(json);
    }

    public static ReadContext parse(File json) throws IOException {
        return new JsonReader().parse(json);
    }

    public static ReadContext parse(URL json) throws IOException {
        return new JsonReader().parse(json);
    }

    public static ReadContext parse(Object json, Configuration configuration) {
        return new JsonReader(configuration).parse(json);
    }

    public static ReadContext parse(String json, Configuration configuration) {
        return new JsonReader(configuration).parse(json);
    }

    public static ReadContext parse(InputStream json, Configuration configuration) {
        return new JsonReader(configuration).parse(json);
    }

    public static ReadContext parse(File json, Configuration configuration) throws IOException {
        return new JsonReader(configuration).parse(json);
    }

    public static ReadContext parse(URL json, Configuration configuration) throws IOException {
        return new JsonReader(configuration).parse(json);
    }
}

