/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.jdbc;

import com.liferay.portal.kernel.jndi.JNDIUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.dao.orm.UpgradeOptimizedConnectionHandler;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DataAccess {
    private static Log _log = LogFactoryUtil.getLog(DataAccess.class);

    public static void cleanUp(Connection connection) {
        block3: {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sqle) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(sqle.getMessage());
            }
        }
    }

    public static void cleanUp(Connection connection, Statement statement) {
        DataAccess.cleanUp(statement);
        DataAccess.cleanUp(connection);
    }

    public static void cleanUp(Connection connection, Statement statement, ResultSet resultSet) {
        DataAccess.cleanUp(resultSet);
        DataAccess.cleanUp(statement);
        DataAccess.cleanUp(connection);
    }

    public static void cleanUp(ResultSet resultSet) {
        block3: {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sqle) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(sqle.getMessage());
            }
        }
    }

    public static void cleanUp(Statement statement) {
        block3: {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sqle) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(sqle.getMessage());
            }
        }
    }

    public static Connection getConnection() throws SQLException {
        DataSource dataSource = InfrastructureUtil.getDataSource();
        return dataSource.getConnection();
    }

    public static Connection getConnection(String location) throws NamingException, SQLException {
        Properties properties = PropsUtil.getProperties("jndi.environment.", true);
        InitialContext context = new InitialContext(properties);
        DataSource dataSource = (DataSource)JNDIUtil.lookup(context, location);
        return dataSource.getConnection();
    }

    public static Connection getUpgradeOptimizedConnection() throws SQLException {
        Connection con = DataAccess.getConnection();
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        return (Connection)ProxyUtil.newProxyInstance(classLoader, new Class[]{Connection.class}, new UpgradeOptimizedConnectionHandler(con));
    }
}

