/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io.delta;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class ByteChannelReader {
    private ByteBuffer _byteBuffer;
    private boolean _eof;
    private ReadableByteChannel _readableByteChannel;

    public ByteChannelReader(ReadableByteChannel readableByteChannel) throws IOException {
        this(readableByteChannel, 1024);
    }

    public ByteChannelReader(ReadableByteChannel readableByteChannel, int bufferLength) throws IOException {
        this._readableByteChannel = readableByteChannel;
        this._byteBuffer = ByteBuffer.allocate(bufferLength);
        this._eof = this._readableByteChannel.read(this._byteBuffer) == -1;
        this._byteBuffer.flip();
    }

    public void ensureData(int length) throws IOException {
        if (this._byteBuffer.remaining() < length) {
            this.read();
            if (this._eof || this._byteBuffer.remaining() < length) {
                throw new IOException("Unexpected EOF");
            }
        }
    }

    public byte get() {
        return this._byteBuffer.get();
    }

    public byte get(int offset) {
        return this._byteBuffer.get(this._byteBuffer.position() + offset);
    }

    public ByteBuffer getBuffer() {
        return this._byteBuffer;
    }

    public boolean hasRemaining() {
        return this._byteBuffer.hasRemaining();
    }

    public void maybeRead(int length) throws IOException {
        if (!this._eof && this._byteBuffer.remaining() < length) {
            this.read();
        }
    }

    public void read() throws IOException {
        if (this._eof) {
            return;
        }
        this._byteBuffer.compact();
        this._eof = this._readableByteChannel.read(this._byteBuffer) == -1;
        this._byteBuffer.flip();
    }

    public int remaining() {
        return this._byteBuffer.remaining();
    }

    public void resizeBuffer(int minBufferLength) {
        if (this._byteBuffer.capacity() >= minBufferLength) {
            return;
        }
        ByteBuffer newBuffer = ByteBuffer.allocate(minBufferLength);
        newBuffer.put(this._byteBuffer);
        newBuffer.flip();
        this._byteBuffer = newBuffer;
    }

    public int skip(int length) {
        length = Math.min(this._byteBuffer.remaining(), length);
        this._byteBuffer.position(this._byteBuffer.position() + length);
        return length;
    }
}

