/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.cache.Lifecycle;
import com.liferay.portal.kernel.cache.ThreadLocalCacheManager;
import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseAsyncDestination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;
import com.liferay.portal.kernel.messaging.MessageRunnable;
import com.liferay.portal.kernel.util.CentralizedThreadLocal;
import java.util.Set;

public class SerialDestination
extends BaseAsyncDestination {
    private static final int _WORKERS_CORE_SIZE = 1;
    private static final int _WORKERS_MAX_SIZE = 1;
    private static Log _log = LogFactoryUtil.getLog(SerialDestination.class);

    public SerialDestination() {
        this.setWorkersCoreSize(1);
        this.setWorkersMaxSize(1);
    }

    public SerialDestination(String name) {
        super(name, 1, 1);
    }

    @Override
    protected void dispatch(final Set<MessageListener> messageListeners, final Message message) {
        ThreadPoolExecutor threadPoolExecutor = this.getThreadPoolExecutor();
        MessageRunnable runnable = new MessageRunnable(message){

            @Override
            public void run() {
                try {
                    SerialDestination.this.populateThreadLocalsFromMessage(message);
                    for (MessageListener messageListener : messageListeners) {
                        try {
                            messageListener.receive(message);
                        }
                        catch (MessageListenerException mle) {
                            _log.error("Unable to process message " + message, mle);
                        }
                    }
                }
                finally {
                    ThreadLocalCacheManager.clearAll(Lifecycle.REQUEST);
                    CentralizedThreadLocal.clearShortLivedThreadLocals();
                }
            }
        };
        threadPoolExecutor.execute(runnable);
    }
}

