/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PersistentHttpServletRequestWrapper;
import com.liferay.portal.kernel.servlet.RequestDispatcherAttributeNames;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class RestrictPortletServletRequest
extends PersistentHttpServletRequestWrapper {
    private static Log _log = LogFactoryUtil.getLog(RestrictPortletServletRequest.class);
    private static Object _nullValue = new Object();
    private Map<String, Object> _attributes = new HashMap<String, Object>();

    public RestrictPortletServletRequest(HttpServletRequest request) {
        super(request);
    }

    public Object getAttribute(String name) {
        if (RequestDispatcherAttributeNames.contains(name)) {
            return super.getAttribute(name);
        }
        Object value = this._attributes.get(name);
        if (value == _nullValue) {
            return null;
        }
        if (value != null) {
            return value;
        }
        return super.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        Enumeration superEnumeration = super.getAttributeNames();
        if (this._attributes.isEmpty()) {
            return superEnumeration;
        }
        HashSet<String> names = new HashSet<String>();
        while (superEnumeration.hasMoreElements()) {
            names.add((String)superEnumeration.nextElement());
        }
        for (Map.Entry<String, Object> entry : this._attributes.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                names.remove(key);
                continue;
            }
            names.add(key);
        }
        names.addAll(this._attributes.keySet());
        return Collections.enumeration(names);
    }

    public Map<String, Object> getAttributes() {
        return this._attributes;
    }

    public void mergeSharedAttributes() {
        ServletRequest servletRequest = this.getRequest();
        for (Map.Entry<String, Object> entry : this._attributes.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (name.startsWith("LIFERAY_SHARED_") || name.startsWith("javax.portlet.") || name.startsWith("javax.servlet.")) {
                if (value == _nullValue) {
                    servletRequest.removeAttribute(name);
                    if (!_log.isInfoEnabled()) continue;
                    _log.info("Remove shared attribute " + name);
                    continue;
                }
                servletRequest.setAttribute(name, value);
                if (!_log.isInfoEnabled()) continue;
                _log.info("Set shared attribute " + name);
                continue;
            }
            if (value == _nullValue || !_log.isDebugEnabled()) continue;
            _log.debug("Ignore setting restricted attribute " + name);
        }
    }

    public void removeAttribute(String name) {
        if (RequestDispatcherAttributeNames.contains(name)) {
            super.removeAttribute(name);
        } else {
            this._attributes.put(name, _nullValue);
        }
    }

    public void setAttribute(String name, Object value) {
        if (RequestDispatcherAttributeNames.contains(name)) {
            super.setAttribute(name, value);
        } else {
            if (value == null) {
                value = _nullValue;
            }
            this._attributes.put(name, value);
        }
    }
}

