/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.servlet.HeaderCacheServletResponse;
import com.liferay.portal.kernel.servlet.PipingServletOutputStream;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class ByteBufferServletResponse
extends HeaderCacheServletResponse {
    private ByteBuffer _byteBuffer;
    private PrintWriter _printWriter;
    private ServletOutputStream _servletOutputStream;
    private UnsyncByteArrayOutputStream _unsyncByteArrayOutputStream;

    public ByteBufferServletResponse(HttpServletResponse response) {
        super(response);
    }

    public int getBufferSize() {
        if (this._byteBuffer != null) {
            return this._byteBuffer.remaining();
        }
        if (this._unsyncByteArrayOutputStream != null) {
            return this._unsyncByteArrayOutputStream.size();
        }
        return 0;
    }

    public ByteBuffer getByteBuffer() {
        if (this._byteBuffer != null) {
            return this._byteBuffer;
        }
        if (this._unsyncByteArrayOutputStream != null) {
            return this._unsyncByteArrayOutputStream.unsafeGetByteBuffer();
        }
        return ByteBuffer.wrap(new byte[0]);
    }

    public ServletOutputStream getOutputStream() {
        if (this._printWriter != null) {
            throw new IllegalStateException("Cannot obtain OutputStream because Writer is already in use");
        }
        if (this._servletOutputStream == null) {
            this._unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            this._servletOutputStream = new PipingServletOutputStream(this._unsyncByteArrayOutputStream);
        }
        return this._servletOutputStream;
    }

    public PrintWriter getWriter() {
        if (this._printWriter != null) {
            return this._printWriter;
        }
        if (this._servletOutputStream != null) {
            throw new IllegalStateException("Cannot obtain Writer because OutputStream is already in use");
        }
        this._unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        this._servletOutputStream = new PipingServletOutputStream(this._unsyncByteArrayOutputStream);
        this._printWriter = UnsyncPrintWriterPool.borrow(this._unsyncByteArrayOutputStream);
        return this._printWriter;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this._byteBuffer = byteBuffer;
    }
}

