/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.StringBundler;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;

public class MethodWrapper
implements Serializable {
    private String[] _argumentClassNames;
    private Object[] _arguments;
    private String _className;
    private String _methodName;

    public MethodWrapper(Method method, Object[] arguments) {
        this(method.getDeclaringClass().getName(), method.getName(), arguments);
        this._argumentClassNames = new String[arguments.length];
        Class<?>[] parameterTypes = method.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            this._argumentClassNames[i] = parameterTypes[i].getName();
            ++i;
        }
    }

    public MethodWrapper(String className, String methodName) {
        this(className, methodName, new Object[0]);
    }

    public MethodWrapper(String className, String methodName, Object argument) {
        this(className, methodName, new Object[]{argument});
    }

    public MethodWrapper(String className, String methodName, Object[] arguments) {
        this._className = className;
        this._methodName = methodName;
        this._arguments = arguments;
    }

    public Object[] getArgs() {
        return this.getArguments();
    }

    public String[] getArgumentClassNames() {
        return this._argumentClassNames;
    }

    public Object[] getArguments() {
        Object[] arguments = new Object[this._arguments.length];
        System.arraycopy(this._arguments, 0, arguments, 0, this._arguments.length);
        return arguments;
    }

    public String getClassName() {
        return this._className;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public String toString() {
        StringBundler sb = new StringBundler(9);
        sb.append("{className=");
        sb.append(this._className);
        sb.append(", methodName=");
        sb.append(this._methodName);
        if (this._argumentClassNames != null) {
            sb.append(", argumentClassNames=");
            sb.append(Arrays.toString(this._argumentClassNames));
        }
        sb.append(", arguments=");
        sb.append(Arrays.toString(this._arguments));
        sb.append("}");
        return sb.toString();
    }
}

