/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.concurrent.ConcurrentHashSet;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ReferenceEntry;
import java.lang.reflect.Field;
import java.util.Set;

public class ReferenceRegistry {
    private static Log _log = LogFactoryUtil.getLog(ReferenceRegistry.class);
    private static Set<ReferenceEntry> _referenceEntries = new ConcurrentHashSet<ReferenceEntry>();

    public static void registerReference(Class<?> clazz, Object object, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            ReferenceEntry referenceEntry = new ReferenceEntry(object, field);
            _referenceEntries.add(referenceEntry);
        }
        catch (SecurityException securityException) {
            if (_log.isWarnEnabled()) {
                _log.warn("Not allowed to get field " + fieldName + " for " + clazz);
            }
        }
        catch (Exception exception) {
            _log.error("Unable to get field " + fieldName + " for " + clazz);
        }
    }

    public static void registerReference(Class<?> clazz, String fieldName) {
        ReferenceRegistry.registerReference(clazz, null, fieldName);
    }

    public static void registerReference(Field field) {
        ReferenceEntry referenceEntry = new ReferenceEntry(field);
        _referenceEntries.add(referenceEntry);
    }

    public static void registerReference(Object object, Field field) {
        ReferenceEntry referenceEntry = new ReferenceEntry(object, field);
        _referenceEntries.add(referenceEntry);
    }

    public static void releaseReferences() {
        for (ReferenceEntry referenceEntry : _referenceEntries) {
            try {
                referenceEntry.setValue(null);
            }
            catch (Exception e) {
                _log.error("Failed to release reference for " + referenceEntry, e);
            }
        }
        _referenceEntries.clear();
    }
}

