/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.UniqueList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

public class ReflectionUtil {
    public static Class<?> getAnnotationDeclaringClass(Class<? extends Annotation> annotationClass, Class<?> clazz) {
        if (clazz == null || clazz.equals(Object.class)) {
            return null;
        }
        if (ReflectionUtil.isAnnotationDeclaredInClass(annotationClass, clazz)) {
            return clazz;
        }
        return ReflectionUtil.getAnnotationDeclaringClass(annotationClass, clazz.getSuperclass());
    }

    public static Field getDeclaredField(Class<?> clazz, String name) throws Exception {
        int modifiers;
        Field field = clazz.getDeclaredField(name);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        if (((modifiers = field.getModifiers()) & 0x10) == 16) {
            Field modifiersField = ReflectionUtil.getDeclaredField(Field.class, "modifiers");
            modifiersField.setInt(field, modifiers & 0xFFFFFFEF);
        }
        return field;
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws Exception {
        Method method = clazz.getDeclaredMethod(name, parameterTypes);
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        return method;
    }

    public static Class<?>[] getInterfaces(Object object) {
        return ReflectionUtil.getInterfaces(object, null);
    }

    public static Class<?>[] getInterfaces(Object object, ClassLoader classLoader) {
        UniqueList interfaceClasses = new UniqueList();
        Class<?> clazz = object.getClass();
        ReflectionUtil._getInterfaces(interfaceClasses, clazz, classLoader);
        Class<?> superClass = clazz.getSuperclass();
        while (superClass != null) {
            ReflectionUtil._getInterfaces(interfaceClasses, superClass, classLoader);
            superClass = superClass.getSuperclass();
        }
        return interfaceClasses.toArray(new Class[interfaceClasses.size()]);
    }

    public static Class<?>[] getParameterTypes(Object[] arguments) {
        if (arguments == null) {
            return null;
        }
        Class[] parameterTypes = new Class[arguments.length];
        int i = 0;
        while (i < arguments.length) {
            parameterTypes[i] = arguments[i] == null ? null : (arguments[i] instanceof Boolean ? Boolean.TYPE : (arguments[i] instanceof Byte ? Byte.TYPE : (arguments[i] instanceof Character ? Character.TYPE : (arguments[i] instanceof Double ? Double.TYPE : (arguments[i] instanceof Float ? Float.TYPE : (arguments[i] instanceof Integer ? Integer.TYPE : (arguments[i] instanceof Long ? Long.TYPE : (arguments[i] instanceof Short ? Short.TYPE : arguments[i].getClass()))))))));
            ++i;
        }
        return parameterTypes;
    }

    public static boolean isAnnotationDeclaredInClass(Class<? extends Annotation> annotationClass, Class<?> clazz) {
        Annotation[] annotations;
        if (annotationClass == null || clazz == null) {
            throw new IllegalArgumentException();
        }
        Annotation[] annotationArray = annotations = clazz.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotationClass.equals(annotation.annotationType())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void _getInterfaces(List<Class<?>> interfaceClasses, Class<?> clazz, ClassLoader classLoader) {
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaceClass = classArray[n2];
            try {
                if (classLoader != null) {
                    interfaceClasses.add(classLoader.loadClass(interfaceClass.getName()));
                } else {
                    interfaceClasses.add(interfaceClass);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
            ++n2;
        }
    }
}

