/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.theme;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.templateparser.TemplateContext;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.theme.RequestVars;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class NavItem
implements Serializable {
    private List<NavItem> _children;
    private Layout _layout;
    private RequestVars _vars;

    public static NavItem fromLayout(RequestVars vars, Layout layout) {
        return new NavItem(vars, layout);
    }

    public static List<NavItem> fromLayouts(RequestVars vars, List<Layout> layouts) {
        if (layouts == null) {
            return null;
        }
        ArrayList<NavItem> navItems = new ArrayList<NavItem>(layouts.size());
        for (Layout layout : layouts) {
            navItems.add(NavItem.fromLayout(vars, layout));
        }
        return navItems;
    }

    public NavItem(RequestVars vars, Layout layout) {
        this._vars = vars;
        this._layout = layout;
    }

    public List<NavItem> getChildren() throws Exception {
        if (this._children == null) {
            ThemeDisplay themeDisplay = this._vars.getThemeDisplay();
            List<Layout> layouts = this._layout.getChildren(themeDisplay.getPermissionChecker());
            this._children = NavItem.fromLayouts(this._vars, layouts);
        }
        return this._children;
    }

    public Layout getLayout() {
        return this._layout;
    }

    public String getName() {
        return HtmlUtil.escape(this.getUnescapedName());
    }

    public String getRegularFullURL() throws Exception {
        String portalURL = PortalUtil.getPortalURL(this._vars.getRequest());
        String regularURL = this.getRegularURL();
        if (StringUtil.startsWith(regularURL, portalURL) || Validator.isUrl(regularURL)) {
            return regularURL;
        }
        return portalURL.concat(regularURL);
    }

    public String getRegularURL() throws Exception {
        return this._layout.getRegularURL(this._vars.getRequest());
    }

    public String getResetLayoutURL() throws Exception {
        return this._layout.getResetLayoutURL(this._vars.getRequest());
    }

    public String getResetMaxStateURL() throws Exception {
        return this._layout.getResetMaxStateURL(this._vars.getRequest());
    }

    public String getTarget() {
        return this._layout.getTarget();
    }

    public String getTitle() {
        return this._layout.getTitle(this._vars.getThemeDisplay().getLocale());
    }

    public String getUnescapedName() {
        return this._layout.getName(this._vars.getThemeDisplay().getLocale());
    }

    public String getURL() throws Exception {
        return HtmlUtil.escapeHREF(this.getRegularFullURL());
    }

    public boolean hasChildren() throws Exception {
        return this.getChildren().size() > 0;
    }

    public void icon() throws Exception {
        TemplateContext templateContext = this._vars.getTemplateContext();
        Object velocityTaglib = templateContext.get("theme");
        Method method = (Method)templateContext.get("velocityTaglib#layoutIcon");
        method.invoke(velocityTaglib, this._layout);
    }

    public boolean isChildSelected() throws PortalException, SystemException {
        ThemeDisplay themeDisplay = this._vars.getThemeDisplay();
        return this._layout.isChildSelected(themeDisplay.isTilesSelectable(), themeDisplay.getLayout());
    }

    public boolean isSelected() {
        ThemeDisplay themeDisplay = this._vars.getThemeDisplay();
        return this._layout.isSelected(themeDisplay.isTilesSelectable(), themeDisplay.getLayout(), this._vars.getAncestorPlid());
    }
}

