/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.storage;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.dynamicdatamapping.StorageException;
import com.liferay.portlet.dynamicdatamapping.StorageFieldNameException;
import com.liferay.portlet.dynamicdatamapping.StorageFieldRequiredException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStorageLink;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStorageLinkLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageAdapter;
import com.liferay.portlet.dynamicdatamapping.storage.query.Condition;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class BaseStorageAdapter
implements StorageAdapter {
    @Override
    public long create(long companyId, long ddmStructureId, Fields fields, ServiceContext serviceContext) throws StorageException {
        try {
            this.validateDDMStructureFields(ddmStructureId, fields);
            return this.doCreate(companyId, ddmStructureId, fields, serviceContext);
        }
        catch (StorageException se) {
            throw se;
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void deleteByClass(long classPK) throws StorageException {
        try {
            this.doDeleteByClass(classPK);
        }
        catch (StorageException se) {
            throw se;
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void deleteByDDMStructure(long ddmStructureId) throws StorageException {
        try {
            this.doDeleteByDDMStructure(ddmStructureId);
        }
        catch (StorageException se) {
            throw se;
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    @Override
    public Fields getFields(long classPK) throws StorageException {
        return this.getFields(classPK, null);
    }

    @Override
    public Fields getFields(long classPK, List<String> fieldNames) throws StorageException {
        try {
            DDMStorageLink ddmStorageLink = DDMStorageLinkLocalServiceUtil.getClassStorageLink(classPK);
            Map<Long, Fields> fieldsMapByClasses = this.getFieldsMap(ddmStorageLink.getStructureId(), new long[]{classPK}, fieldNames);
            return fieldsMapByClasses.get(classPK);
        }
        catch (StorageException se) {
            throw se;
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    @Override
    public List<Fields> getFieldsList(long ddmStructureId, List<String> fieldNames) throws StorageException {
        return this.getFieldsList(ddmStructureId, fieldNames, null);
    }

    @Override
    public List<Fields> getFieldsList(long ddmStructureId, List<String> fieldNames, OrderByComparator orderByComparator) throws StorageException {
        try {
            return this.doGetFieldsListByDDMStructure(ddmStructureId, fieldNames, orderByComparator);
        }
        catch (StorageException se) {
            throw se;
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    @Override
    public List<Fields> getFieldsList(long ddmStructureId, long[] classPKs, List<String> fieldNames, OrderByComparator orderByComparator) throws StorageException {
        try {
            return this.doGetFieldsListByClasses(ddmStructureId, classPKs, fieldNames, orderByComparator);
        }
        catch (StorageException se) {
            throw se;
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    @Override
    public List<Fields> getFieldsList(long ddmStructureId, long[] classPKs, OrderByComparator orderByComparator) throws StorageException {
        return this.getFieldsList(ddmStructureId, classPKs, null, orderByComparator);
    }

    @Override
    public Map<Long, Fields> getFieldsMap(long ddmStructureId, long[] classPKs) throws StorageException {
        return this.getFieldsMap(ddmStructureId, classPKs, null);
    }

    @Override
    public Map<Long, Fields> getFieldsMap(long ddmStructureId, long[] classPKs, List<String> fieldNames) throws StorageException {
        try {
            return this.doGetFieldsMapByClasses(ddmStructureId, classPKs, fieldNames);
        }
        catch (StorageException se) {
            throw se;
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    @Override
    public List<Fields> query(long ddmStructureId, List<String> fieldNames, Condition condition, OrderByComparator orderByComparator) throws StorageException {
        try {
            return this.doQuery(ddmStructureId, fieldNames, condition, orderByComparator);
        }
        catch (StorageException se) {
            throw se;
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    @Override
    public int queryCount(long ddmStructureId, Condition condition) throws StorageException {
        try {
            return this.doQueryCount(ddmStructureId, condition);
        }
        catch (StorageException se) {
            throw se;
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void update(long classPK, Fields fields, boolean mergeFields, ServiceContext serviceContext) throws StorageException {
        try {
            this.validateClassFields(classPK, fields);
            this.doUpdate(classPK, fields, mergeFields, serviceContext);
        }
        catch (StorageException se) {
            throw se;
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void update(long classPK, Fields fields, ServiceContext serviceContext) throws StorageException {
        this.update(classPK, fields, false, serviceContext);
    }

    protected abstract long doCreate(long var1, long var3, Fields var5, ServiceContext var6) throws Exception;

    protected abstract void doDeleteByClass(long var1) throws Exception;

    protected abstract void doDeleteByDDMStructure(long var1) throws Exception;

    protected abstract List<Fields> doGetFieldsListByClasses(long var1, long[] var3, List<String> var4, OrderByComparator var5) throws Exception;

    protected abstract List<Fields> doGetFieldsListByDDMStructure(long var1, List<String> var3, OrderByComparator var4) throws Exception;

    protected abstract Map<Long, Fields> doGetFieldsMapByClasses(long var1, long[] var3, List<String> var4) throws Exception;

    protected abstract List<Fields> doQuery(long var1, List<String> var3, Condition var4, OrderByComparator var5) throws Exception;

    protected abstract int doQueryCount(long var1, Condition var3) throws Exception;

    protected abstract void doUpdate(long var1, Fields var3, boolean var4, ServiceContext var5) throws Exception;

    protected void validateClassFields(long classPK, Fields fields) throws PortalException, SystemException {
        DDMStorageLink ddmStorageLink = DDMStorageLinkLocalServiceUtil.getClassStorageLink(classPK);
        this.validateDDMStructureFields(ddmStorageLink.getStructureId(), fields);
    }

    protected void validateDDMStructureFields(long ddmStructureId, Fields fields) throws PortalException, SystemException {
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getDDMStructure(ddmStructureId);
        Iterator<Field> itr = fields.iterator();
        while (itr.hasNext()) {
            Field field = itr.next();
            if (!ddmStructure.hasField(field.getName())) {
                throw new StorageFieldNameException();
            }
            if (!ddmStructure.getFieldRequired(field.getName()) || !Validator.isNull(field.getValue())) continue;
            throw new StorageFieldRequiredException();
        }
    }
}

