/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.marathon.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.malinskiy.marathon.config.exceptions.ConfigurationException;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=AnnotationDataFilterConfiguration.class, name="annotationData"), @JsonSubTypes.Type(value=AnnotationFilterConfiguration.class, name="annotation"), @JsonSubTypes.Type(value=CompositionFilterConfiguration.class, name="composition"), @JsonSubTypes.Type(value=FragmentationFilterConfiguration.class, name="fragmentation"), @JsonSubTypes.Type(value=FullyQualifiedClassnameFilterConfiguration.class, name="fully-qualified-class-name"), @JsonSubTypes.Type(value=FullyQualifiedTestnameFilterConfiguration.class, name="fully-qualified-test-name"), @JsonSubTypes.Type(value=SimpleClassnameFilterConfiguration.class, name="simple-class-name"), @JsonSubTypes.Type(value=TestMethodFilterConfiguration.class, name="method"), @JsonSubTypes.Type(value=TestPackageFilterConfiguration.class, name="package"), @JsonSubTypes.Type(value=AllureFilterConfiguration.class, name="allure")})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\n\u0005\u0006\u0007\b\t\n\u000b\f\r\u000eB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&\u0082\u0001\n\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration;", "", "()V", "validate", "", "AllureFilterConfiguration", "AnnotationDataFilterConfiguration", "AnnotationFilterConfiguration", "CompositionFilterConfiguration", "FragmentationFilterConfiguration", "FullyQualifiedClassnameFilterConfiguration", "FullyQualifiedTestnameFilterConfiguration", "SimpleClassnameFilterConfiguration", "TestMethodFilterConfiguration", "TestPackageFilterConfiguration", "Lcom/malinskiy/marathon/config/TestFilterConfiguration$SimpleClassnameFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration$FullyQualifiedClassnameFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration$TestPackageFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration$AnnotationDataFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration$FullyQualifiedTestnameFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration$FragmentationFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration$TestMethodFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration$AnnotationFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration$CompositionFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration$AllureFilterConfiguration;", "configuration"})
public abstract class TestFilterConfiguration {
    private TestFilterConfiguration() {
    }

    public abstract void validate();

    public /* synthetic */ TestFilterConfiguration(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u00c6\u0003J3\u0010\u0013\u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u0006H\u00d6\u0001J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration$SimpleClassnameFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration;", "regex", "Lkotlin/text/Regex;", "values", "", "", "file", "Ljava/io/File;", "(Lkotlin/text/Regex;Ljava/util/List;Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "getRegex", "()Lkotlin/text/Regex;", "getValues", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "validate", "", "configuration"})
    public static final class SimpleClassnameFilterConfiguration
    extends TestFilterConfiguration {
        @Nullable
        private final Regex regex;
        @Nullable
        private final List<String> values;
        @Nullable
        private final File file;

        public SimpleClassnameFilterConfiguration(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file) {
            super(null);
            this.regex = regex;
            this.values = values;
            this.file = file;
        }

        public /* synthetic */ SimpleClassnameFilterConfiguration(Regex regex, List list, File file, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                regex = null;
            }
            if ((n & 2) != 0) {
                list = null;
            }
            if ((n & 4) != 0) {
                file = null;
            }
            this(regex, list, file);
        }

        @Nullable
        public final Regex getRegex() {
            return this.regex;
        }

        @Nullable
        public final List<String> getValues() {
            return this.values;
        }

        @Nullable
        public final File getFile() {
            return this.file;
        }

        @Override
        public void validate() {
            int n;
            int i = 0;
            if (this.regex != null) {
                n = i;
                i = n + 1;
            }
            if (this.values != null) {
                n = i;
                i = n + 1;
            }
            if (this.file != null) {
                n = i;
                i = n + 1;
            }
            if (i > 1) {
                throw new ConfigurationException(Intrinsics.stringPlus((String)"Only one of [regex,values,file] can be specified for ", (Object)Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName()));
            }
            if (i == 0) {
                throw new ConfigurationException(Intrinsics.stringPlus((String)"At least one of [regex,values,file] should be specified for ", (Object)Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName()));
            }
        }

        public boolean equals(@Nullable Object other) {
            Object object;
            if (this == other) {
                return true;
            }
            if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
                return false;
            }
            if (other == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.malinskiy.marathon.config.TestFilterConfiguration.SimpleClassnameFilterConfiguration");
            }
            SimpleClassnameFilterConfiguration cfr_ignored_0 = (SimpleClassnameFilterConfiguration)other;
            object = String.valueOf(this.regex);
            CharSequence charSequence = String.valueOf(((SimpleClassnameFilterConfiguration)other).regex);
            boolean bl = false;
            Object object2 = object;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            if (!((String)object2).contentEquals(charSequence)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.values, ((SimpleClassnameFilterConfiguration)other).values)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.file, (Object)((SimpleClassnameFilterConfiguration)other).file);
        }

        public int hashCode() {
            int n;
            Object object = this.regex;
            int result = object == null ? 0 : (n = object.hashCode());
            object = this.values;
            result = 31 * result + (object == null ? 0 : (n = object.hashCode()));
            object = this.file;
            result = 31 * result + (object == null ? 0 : (n = ((File)object).hashCode()));
            return result;
        }

        @Nullable
        public final Regex component1() {
            return this.regex;
        }

        @Nullable
        public final List<String> component2() {
            return this.values;
        }

        @Nullable
        public final File component3() {
            return this.file;
        }

        @NotNull
        public final SimpleClassnameFilterConfiguration copy(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file) {
            return new SimpleClassnameFilterConfiguration(regex, values, file);
        }

        public static /* synthetic */ SimpleClassnameFilterConfiguration copy$default(SimpleClassnameFilterConfiguration simpleClassnameFilterConfiguration, Regex regex, List list, File file, int n, Object object) {
            if ((n & 1) != 0) {
                regex = simpleClassnameFilterConfiguration.regex;
            }
            if ((n & 2) != 0) {
                list = simpleClassnameFilterConfiguration.values;
            }
            if ((n & 4) != 0) {
                file = simpleClassnameFilterConfiguration.file;
            }
            return simpleClassnameFilterConfiguration.copy(regex, list, file);
        }

        @NotNull
        public String toString() {
            return "SimpleClassnameFilterConfiguration(regex=" + this.regex + ", values=" + this.values + ", file=" + this.file + ')';
        }

        public SimpleClassnameFilterConfiguration() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u00c6\u0003J3\u0010\u0013\u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u0006H\u00d6\u0001J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration$FullyQualifiedClassnameFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration;", "regex", "Lkotlin/text/Regex;", "values", "", "", "file", "Ljava/io/File;", "(Lkotlin/text/Regex;Ljava/util/List;Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "getRegex", "()Lkotlin/text/Regex;", "getValues", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "validate", "", "configuration"})
    public static final class FullyQualifiedClassnameFilterConfiguration
    extends TestFilterConfiguration {
        @Nullable
        private final Regex regex;
        @Nullable
        private final List<String> values;
        @Nullable
        private final File file;

        public FullyQualifiedClassnameFilterConfiguration(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file) {
            super(null);
            this.regex = regex;
            this.values = values;
            this.file = file;
        }

        public /* synthetic */ FullyQualifiedClassnameFilterConfiguration(Regex regex, List list, File file, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                regex = null;
            }
            if ((n & 2) != 0) {
                list = null;
            }
            if ((n & 4) != 0) {
                file = null;
            }
            this(regex, list, file);
        }

        @Nullable
        public final Regex getRegex() {
            return this.regex;
        }

        @Nullable
        public final List<String> getValues() {
            return this.values;
        }

        @Nullable
        public final File getFile() {
            return this.file;
        }

        @Override
        public void validate() {
            int n;
            int i = 0;
            if (this.regex != null) {
                n = i;
                i = n + 1;
            }
            if (this.values != null) {
                n = i;
                i = n + 1;
            }
            if (this.file != null) {
                n = i;
                i = n + 1;
            }
            if (i > 1) {
                throw new ConfigurationException(Intrinsics.stringPlus((String)"Only one of [regex,values,file] can be specified for ", (Object)Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName()));
            }
            if (i == 0) {
                throw new ConfigurationException(Intrinsics.stringPlus((String)"At least one of [regex,values,file] should be specified for ", (Object)Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName()));
            }
        }

        public boolean equals(@Nullable Object other) {
            Object object;
            if (this == other) {
                return true;
            }
            if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
                return false;
            }
            if (other == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.malinskiy.marathon.config.TestFilterConfiguration.FullyQualifiedClassnameFilterConfiguration");
            }
            FullyQualifiedClassnameFilterConfiguration cfr_ignored_0 = (FullyQualifiedClassnameFilterConfiguration)other;
            object = String.valueOf(this.regex);
            CharSequence charSequence = String.valueOf(((FullyQualifiedClassnameFilterConfiguration)other).regex);
            boolean bl = false;
            Object object2 = object;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            if (!((String)object2).contentEquals(charSequence)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.values, ((FullyQualifiedClassnameFilterConfiguration)other).values)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.file, (Object)((FullyQualifiedClassnameFilterConfiguration)other).file);
        }

        public int hashCode() {
            int n;
            Object object = this.regex;
            int result = object == null ? 0 : (n = object.hashCode());
            object = this.values;
            result = 31 * result + (object == null ? 0 : (n = object.hashCode()));
            object = this.file;
            result = 31 * result + (object == null ? 0 : (n = ((File)object).hashCode()));
            return result;
        }

        @Nullable
        public final Regex component1() {
            return this.regex;
        }

        @Nullable
        public final List<String> component2() {
            return this.values;
        }

        @Nullable
        public final File component3() {
            return this.file;
        }

        @NotNull
        public final FullyQualifiedClassnameFilterConfiguration copy(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file) {
            return new FullyQualifiedClassnameFilterConfiguration(regex, values, file);
        }

        public static /* synthetic */ FullyQualifiedClassnameFilterConfiguration copy$default(FullyQualifiedClassnameFilterConfiguration fullyQualifiedClassnameFilterConfiguration, Regex regex, List list, File file, int n, Object object) {
            if ((n & 1) != 0) {
                regex = fullyQualifiedClassnameFilterConfiguration.regex;
            }
            if ((n & 2) != 0) {
                list = fullyQualifiedClassnameFilterConfiguration.values;
            }
            if ((n & 4) != 0) {
                file = fullyQualifiedClassnameFilterConfiguration.file;
            }
            return fullyQualifiedClassnameFilterConfiguration.copy(regex, list, file);
        }

        @NotNull
        public String toString() {
            return "FullyQualifiedClassnameFilterConfiguration(regex=" + this.regex + ", values=" + this.values + ", file=" + this.file + ')';
        }

        public FullyQualifiedClassnameFilterConfiguration() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u00c6\u0003J3\u0010\u0013\u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u0006H\u00d6\u0001J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration$TestPackageFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration;", "regex", "Lkotlin/text/Regex;", "values", "", "", "file", "Ljava/io/File;", "(Lkotlin/text/Regex;Ljava/util/List;Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "getRegex", "()Lkotlin/text/Regex;", "getValues", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "validate", "", "configuration"})
    public static final class TestPackageFilterConfiguration
    extends TestFilterConfiguration {
        @Nullable
        private final Regex regex;
        @Nullable
        private final List<String> values;
        @Nullable
        private final File file;

        public TestPackageFilterConfiguration(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file) {
            super(null);
            this.regex = regex;
            this.values = values;
            this.file = file;
        }

        public /* synthetic */ TestPackageFilterConfiguration(Regex regex, List list, File file, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                regex = null;
            }
            if ((n & 2) != 0) {
                list = null;
            }
            if ((n & 4) != 0) {
                file = null;
            }
            this(regex, list, file);
        }

        @Nullable
        public final Regex getRegex() {
            return this.regex;
        }

        @Nullable
        public final List<String> getValues() {
            return this.values;
        }

        @Nullable
        public final File getFile() {
            return this.file;
        }

        @Override
        public void validate() {
            int n;
            int i = 0;
            if (this.regex != null) {
                n = i;
                i = n + 1;
            }
            if (this.values != null) {
                n = i;
                i = n + 1;
            }
            if (this.file != null) {
                n = i;
                i = n + 1;
            }
            if (i > 1) {
                throw new ConfigurationException(Intrinsics.stringPlus((String)"Only one of [regex,values,file] can be specified for ", (Object)Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName()));
            }
            if (i == 0) {
                throw new ConfigurationException(Intrinsics.stringPlus((String)"At least one of [regex,values,file] should be specified for ", (Object)Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName()));
            }
        }

        public boolean equals(@Nullable Object other) {
            Object object;
            if (this == other) {
                return true;
            }
            if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
                return false;
            }
            if (other == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.malinskiy.marathon.config.TestFilterConfiguration.TestPackageFilterConfiguration");
            }
            TestPackageFilterConfiguration cfr_ignored_0 = (TestPackageFilterConfiguration)other;
            object = String.valueOf(this.regex);
            CharSequence charSequence = String.valueOf(((TestPackageFilterConfiguration)other).regex);
            boolean bl = false;
            Object object2 = object;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            if (!((String)object2).contentEquals(charSequence)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.values, ((TestPackageFilterConfiguration)other).values)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.file, (Object)((TestPackageFilterConfiguration)other).file);
        }

        public int hashCode() {
            int n;
            Object object = this.regex;
            int result = object == null ? 0 : (n = object.hashCode());
            object = this.values;
            result = 31 * result + (object == null ? 0 : (n = object.hashCode()));
            object = this.file;
            result = 31 * result + (object == null ? 0 : (n = ((File)object).hashCode()));
            return result;
        }

        @Nullable
        public final Regex component1() {
            return this.regex;
        }

        @Nullable
        public final List<String> component2() {
            return this.values;
        }

        @Nullable
        public final File component3() {
            return this.file;
        }

        @NotNull
        public final TestPackageFilterConfiguration copy(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file) {
            return new TestPackageFilterConfiguration(regex, values, file);
        }

        public static /* synthetic */ TestPackageFilterConfiguration copy$default(TestPackageFilterConfiguration testPackageFilterConfiguration, Regex regex, List list, File file, int n, Object object) {
            if ((n & 1) != 0) {
                regex = testPackageFilterConfiguration.regex;
            }
            if ((n & 2) != 0) {
                list = testPackageFilterConfiguration.values;
            }
            if ((n & 4) != 0) {
                file = testPackageFilterConfiguration.file;
            }
            return testPackageFilterConfiguration.copy(regex, list, file);
        }

        @NotNull
        public String toString() {
            return "TestPackageFilterConfiguration(regex=" + this.regex + ", values=" + this.values + ", file=" + this.file + ')';
        }

        public TestPackageFilterConfiguration() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration$AnnotationDataFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration;", "nameRegex", "Lkotlin/text/Regex;", "valueRegex", "(Lkotlin/text/Regex;Lkotlin/text/Regex;)V", "getNameRegex", "()Lkotlin/text/Regex;", "getValueRegex", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "validate", "", "configuration"})
    public static final class AnnotationDataFilterConfiguration
    extends TestFilterConfiguration {
        @NotNull
        private final Regex nameRegex;
        @NotNull
        private final Regex valueRegex;

        public AnnotationDataFilterConfiguration(@JsonProperty(value="nameRegex") @NotNull Regex nameRegex, @JsonProperty(value="valueRegex") @NotNull Regex valueRegex) {
            Intrinsics.checkNotNullParameter((Object)nameRegex, (String)"nameRegex");
            Intrinsics.checkNotNullParameter((Object)valueRegex, (String)"valueRegex");
            super(null);
            this.nameRegex = nameRegex;
            this.valueRegex = valueRegex;
        }

        @NotNull
        public final Regex getNameRegex() {
            return this.nameRegex;
        }

        @NotNull
        public final Regex getValueRegex() {
            return this.valueRegex;
        }

        @Override
        public void validate() {
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof AnnotationDataFilterConfiguration)) {
                return false;
            }
            String string = "" + this.nameRegex + this.valueRegex;
            CharSequence charSequence = "" + ((AnnotationDataFilterConfiguration)other).nameRegex + ((AnnotationDataFilterConfiguration)other).valueRegex;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            return string2.contentEquals(charSequence);
        }

        public int hashCode() {
            return this.nameRegex.hashCode() + this.valueRegex.hashCode();
        }

        @NotNull
        public final Regex component1() {
            return this.nameRegex;
        }

        @NotNull
        public final Regex component2() {
            return this.valueRegex;
        }

        @NotNull
        public final AnnotationDataFilterConfiguration copy(@JsonProperty(value="nameRegex") @NotNull Regex nameRegex, @JsonProperty(value="valueRegex") @NotNull Regex valueRegex) {
            Intrinsics.checkNotNullParameter((Object)nameRegex, (String)"nameRegex");
            Intrinsics.checkNotNullParameter((Object)valueRegex, (String)"valueRegex");
            return new AnnotationDataFilterConfiguration(nameRegex, valueRegex);
        }

        public static /* synthetic */ AnnotationDataFilterConfiguration copy$default(AnnotationDataFilterConfiguration annotationDataFilterConfiguration, Regex regex, Regex regex2, int n, Object object) {
            if ((n & 1) != 0) {
                regex = annotationDataFilterConfiguration.nameRegex;
            }
            if ((n & 2) != 0) {
                regex2 = annotationDataFilterConfiguration.valueRegex;
            }
            return annotationDataFilterConfiguration.copy(regex, regex2);
        }

        @NotNull
        public String toString() {
            return "AnnotationDataFilterConfiguration(nameRegex=" + this.nameRegex + ", valueRegex=" + this.valueRegex + ')';
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u00c6\u0003J3\u0010\u0013\u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u0006H\u00d6\u0001J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration$FullyQualifiedTestnameFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration;", "regex", "Lkotlin/text/Regex;", "values", "", "", "file", "Ljava/io/File;", "(Lkotlin/text/Regex;Ljava/util/List;Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "getRegex", "()Lkotlin/text/Regex;", "getValues", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "validate", "", "configuration"})
    public static final class FullyQualifiedTestnameFilterConfiguration
    extends TestFilterConfiguration {
        @Nullable
        private final Regex regex;
        @Nullable
        private final List<String> values;
        @Nullable
        private final File file;

        public FullyQualifiedTestnameFilterConfiguration(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file) {
            super(null);
            this.regex = regex;
            this.values = values;
            this.file = file;
        }

        public /* synthetic */ FullyQualifiedTestnameFilterConfiguration(Regex regex, List list, File file, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                regex = null;
            }
            if ((n & 2) != 0) {
                list = null;
            }
            if ((n & 4) != 0) {
                file = null;
            }
            this(regex, list, file);
        }

        @Nullable
        public final Regex getRegex() {
            return this.regex;
        }

        @Nullable
        public final List<String> getValues() {
            return this.values;
        }

        @Nullable
        public final File getFile() {
            return this.file;
        }

        @Override
        public void validate() {
            int n;
            int i = 0;
            if (this.regex != null) {
                n = i;
                i = n + 1;
            }
            if (this.values != null) {
                n = i;
                i = n + 1;
            }
            if (this.file != null) {
                n = i;
                i = n + 1;
            }
            if (i > 1) {
                throw new ConfigurationException(Intrinsics.stringPlus((String)"Only one of [regex,values,file] can be specified for ", (Object)Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName()));
            }
            if (i == 0) {
                throw new ConfigurationException(Intrinsics.stringPlus((String)"At least one of [regex,values,file] should be specified for ", (Object)Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName()));
            }
        }

        public boolean equals(@Nullable Object other) {
            Object object;
            if (this == other) {
                return true;
            }
            if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
                return false;
            }
            if (other == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.malinskiy.marathon.config.TestFilterConfiguration.FullyQualifiedTestnameFilterConfiguration");
            }
            FullyQualifiedTestnameFilterConfiguration cfr_ignored_0 = (FullyQualifiedTestnameFilterConfiguration)other;
            object = String.valueOf(this.regex);
            CharSequence charSequence = String.valueOf(((FullyQualifiedTestnameFilterConfiguration)other).regex);
            boolean bl = false;
            Object object2 = object;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            if (!((String)object2).contentEquals(charSequence)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.values, ((FullyQualifiedTestnameFilterConfiguration)other).values)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.file, (Object)((FullyQualifiedTestnameFilterConfiguration)other).file);
        }

        public int hashCode() {
            int n;
            Object object = this.regex;
            int result = object == null ? 0 : (n = object.hashCode());
            object = this.values;
            result = 31 * result + (object == null ? 0 : (n = object.hashCode()));
            object = this.file;
            result = 31 * result + (object == null ? 0 : (n = ((File)object).hashCode()));
            return result;
        }

        @Nullable
        public final Regex component1() {
            return this.regex;
        }

        @Nullable
        public final List<String> component2() {
            return this.values;
        }

        @Nullable
        public final File component3() {
            return this.file;
        }

        @NotNull
        public final FullyQualifiedTestnameFilterConfiguration copy(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file) {
            return new FullyQualifiedTestnameFilterConfiguration(regex, values, file);
        }

        public static /* synthetic */ FullyQualifiedTestnameFilterConfiguration copy$default(FullyQualifiedTestnameFilterConfiguration fullyQualifiedTestnameFilterConfiguration, Regex regex, List list, File file, int n, Object object) {
            if ((n & 1) != 0) {
                regex = fullyQualifiedTestnameFilterConfiguration.regex;
            }
            if ((n & 2) != 0) {
                list = fullyQualifiedTestnameFilterConfiguration.values;
            }
            if ((n & 4) != 0) {
                file = fullyQualifiedTestnameFilterConfiguration.file;
            }
            return fullyQualifiedTestnameFilterConfiguration.copy(regex, list, file);
        }

        @NotNull
        public String toString() {
            return "FullyQualifiedTestnameFilterConfiguration(regex=" + this.regex + ", values=" + this.values + ", file=" + this.file + ')';
        }

        public FullyQualifiedTestnameFilterConfiguration() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration$FragmentationFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration;", "index", "", "count", "(II)V", "getCount", "()I", "getIndex", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "validate", "", "configuration"})
    public static final class FragmentationFilterConfiguration
    extends TestFilterConfiguration {
        private final int index;
        private final int count;

        public FragmentationFilterConfiguration(int index, int count) {
            super(null);
            this.index = index;
            this.count = count;
        }

        public final int getIndex() {
            return this.index;
        }

        public final int getCount() {
            return this.count;
        }

        @Override
        public void validate() {
            if (this.index < 0) {
                throw new ConfigurationException("Fragment index [" + this.index + "] should be >= 0");
            }
            if (this.count < 0) {
                throw new ConfigurationException("Fragment count [" + this.count + "] should be >= 0");
            }
            if (this.index >= this.count) {
                throw new ConfigurationException("Fragment index [" + this.index + "] should be less than count [" + this.count + ']');
            }
        }

        public final int component1() {
            return this.index;
        }

        public final int component2() {
            return this.count;
        }

        @NotNull
        public final FragmentationFilterConfiguration copy(int index, int count) {
            return new FragmentationFilterConfiguration(index, count);
        }

        public static /* synthetic */ FragmentationFilterConfiguration copy$default(FragmentationFilterConfiguration fragmentationFilterConfiguration, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = fragmentationFilterConfiguration.index;
            }
            if ((n3 & 2) != 0) {
                n2 = fragmentationFilterConfiguration.count;
            }
            return fragmentationFilterConfiguration.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "FragmentationFilterConfiguration(index=" + this.index + ", count=" + this.count + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.index);
            result = result * 31 + Integer.hashCode(this.count);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FragmentationFilterConfiguration)) {
                return false;
            }
            FragmentationFilterConfiguration fragmentationFilterConfiguration = (FragmentationFilterConfiguration)other;
            if (this.index != fragmentationFilterConfiguration.index) {
                return false;
            }
            return this.count == fragmentationFilterConfiguration.count;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u00c6\u0003J3\u0010\u0013\u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u0006H\u00d6\u0001J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration$TestMethodFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration;", "regex", "Lkotlin/text/Regex;", "values", "", "", "file", "Ljava/io/File;", "(Lkotlin/text/Regex;Ljava/util/List;Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "getRegex", "()Lkotlin/text/Regex;", "getValues", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "validate", "", "configuration"})
    public static final class TestMethodFilterConfiguration
    extends TestFilterConfiguration {
        @Nullable
        private final Regex regex;
        @Nullable
        private final List<String> values;
        @Nullable
        private final File file;

        public TestMethodFilterConfiguration(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file) {
            super(null);
            this.regex = regex;
            this.values = values;
            this.file = file;
        }

        public /* synthetic */ TestMethodFilterConfiguration(Regex regex, List list, File file, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                regex = null;
            }
            if ((n & 2) != 0) {
                list = null;
            }
            if ((n & 4) != 0) {
                file = null;
            }
            this(regex, list, file);
        }

        @Nullable
        public final Regex getRegex() {
            return this.regex;
        }

        @Nullable
        public final List<String> getValues() {
            return this.values;
        }

        @Nullable
        public final File getFile() {
            return this.file;
        }

        @Override
        public void validate() {
            int n;
            int i = 0;
            if (this.regex != null) {
                n = i;
                i = n + 1;
            }
            if (this.values != null) {
                n = i;
                i = n + 1;
            }
            if (this.file != null) {
                n = i;
                i = n + 1;
            }
            if (i > 1) {
                throw new ConfigurationException(Intrinsics.stringPlus((String)"Only one of [regex,values,file] can be specified for ", (Object)Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName()));
            }
            if (i == 0) {
                throw new ConfigurationException(Intrinsics.stringPlus((String)"At least one of [regex,values,file] should be specified for ", (Object)Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName()));
            }
        }

        public boolean equals(@Nullable Object other) {
            Object object;
            if (this == other) {
                return true;
            }
            if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
                return false;
            }
            if (other == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.malinskiy.marathon.config.TestFilterConfiguration.TestMethodFilterConfiguration");
            }
            TestMethodFilterConfiguration cfr_ignored_0 = (TestMethodFilterConfiguration)other;
            object = String.valueOf(this.regex);
            CharSequence charSequence = String.valueOf(((TestMethodFilterConfiguration)other).regex);
            boolean bl = false;
            Object object2 = object;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            if (!((String)object2).contentEquals(charSequence)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.values, ((TestMethodFilterConfiguration)other).values)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.file, (Object)((TestMethodFilterConfiguration)other).file);
        }

        public int hashCode() {
            int n;
            Object object = this.regex;
            int result = object == null ? 0 : (n = object.hashCode());
            object = this.values;
            result = 31 * result + (object == null ? 0 : (n = object.hashCode()));
            object = this.file;
            result = 31 * result + (object == null ? 0 : (n = ((File)object).hashCode()));
            return result;
        }

        @Nullable
        public final Regex component1() {
            return this.regex;
        }

        @Nullable
        public final List<String> component2() {
            return this.values;
        }

        @Nullable
        public final File component3() {
            return this.file;
        }

        @NotNull
        public final TestMethodFilterConfiguration copy(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file) {
            return new TestMethodFilterConfiguration(regex, values, file);
        }

        public static /* synthetic */ TestMethodFilterConfiguration copy$default(TestMethodFilterConfiguration testMethodFilterConfiguration, Regex regex, List list, File file, int n, Object object) {
            if ((n & 1) != 0) {
                regex = testMethodFilterConfiguration.regex;
            }
            if ((n & 2) != 0) {
                list = testMethodFilterConfiguration.values;
            }
            if ((n & 4) != 0) {
                file = testMethodFilterConfiguration.file;
            }
            return testMethodFilterConfiguration.copy(regex, list, file);
        }

        @NotNull
        public String toString() {
            return "TestMethodFilterConfiguration(regex=" + this.regex + ", values=" + this.values + ", file=" + this.file + ')';
        }

        public TestMethodFilterConfiguration() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u00c6\u0003J3\u0010\u0013\u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u0006H\u00d6\u0001J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration$AnnotationFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration;", "regex", "Lkotlin/text/Regex;", "values", "", "", "file", "Ljava/io/File;", "(Lkotlin/text/Regex;Ljava/util/List;Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "getRegex", "()Lkotlin/text/Regex;", "getValues", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "validate", "", "configuration"})
    public static final class AnnotationFilterConfiguration
    extends TestFilterConfiguration {
        @Nullable
        private final Regex regex;
        @Nullable
        private final List<String> values;
        @Nullable
        private final File file;

        public AnnotationFilterConfiguration(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file) {
            super(null);
            this.regex = regex;
            this.values = values;
            this.file = file;
        }

        public /* synthetic */ AnnotationFilterConfiguration(Regex regex, List list, File file, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                regex = null;
            }
            if ((n & 2) != 0) {
                list = null;
            }
            if ((n & 4) != 0) {
                file = null;
            }
            this(regex, list, file);
        }

        @Nullable
        public final Regex getRegex() {
            return this.regex;
        }

        @Nullable
        public final List<String> getValues() {
            return this.values;
        }

        @Nullable
        public final File getFile() {
            return this.file;
        }

        @Override
        public void validate() {
            int n;
            int i = 0;
            if (this.regex != null) {
                n = i;
                i = n + 1;
            }
            if (this.values != null) {
                n = i;
                i = n + 1;
            }
            if (this.file != null) {
                n = i;
                i = n + 1;
            }
            if (i > 1) {
                throw new ConfigurationException(Intrinsics.stringPlus((String)"Only one of [regex,values,file] can be specified for ", (Object)Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName()));
            }
            if (i == 0) {
                throw new ConfigurationException(Intrinsics.stringPlus((String)"At least one of [regex,values,file] should be specified for ", (Object)Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName()));
            }
        }

        public boolean equals(@Nullable Object other) {
            Object object;
            if (this == other) {
                return true;
            }
            if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
                return false;
            }
            if (other == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.malinskiy.marathon.config.TestFilterConfiguration.AnnotationFilterConfiguration");
            }
            AnnotationFilterConfiguration cfr_ignored_0 = (AnnotationFilterConfiguration)other;
            object = String.valueOf(this.regex);
            CharSequence charSequence = String.valueOf(((AnnotationFilterConfiguration)other).regex);
            boolean bl = false;
            Object object2 = object;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            if (!((String)object2).contentEquals(charSequence)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.values, ((AnnotationFilterConfiguration)other).values)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.file, (Object)((AnnotationFilterConfiguration)other).file);
        }

        public int hashCode() {
            int n;
            Object object = this.regex;
            int result = object == null ? 0 : (n = object.hashCode());
            object = this.values;
            result = 31 * result + (object == null ? 0 : (n = object.hashCode()));
            object = this.file;
            result = 31 * result + (object == null ? 0 : (n = ((File)object).hashCode()));
            return result;
        }

        @Nullable
        public final Regex component1() {
            return this.regex;
        }

        @Nullable
        public final List<String> component2() {
            return this.values;
        }

        @Nullable
        public final File component3() {
            return this.file;
        }

        @NotNull
        public final AnnotationFilterConfiguration copy(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file) {
            return new AnnotationFilterConfiguration(regex, values, file);
        }

        public static /* synthetic */ AnnotationFilterConfiguration copy$default(AnnotationFilterConfiguration annotationFilterConfiguration, Regex regex, List list, File file, int n, Object object) {
            if ((n & 1) != 0) {
                regex = annotationFilterConfiguration.regex;
            }
            if ((n & 2) != 0) {
                list = annotationFilterConfiguration.values;
            }
            if ((n & 4) != 0) {
                file = annotationFilterConfiguration.file;
            }
            return annotationFilterConfiguration.copy(regex, list, file);
        }

        @NotNull
        public String toString() {
            return "AnnotationFilterConfiguration(regex=" + this.regex + ", values=" + this.values + ", file=" + this.file + ')';
        }

        public AnnotationFilterConfiguration() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u0018B\u001f\u0012\u000e\b\u0001\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration$CompositionFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration;", "filters", "", "op", "Lcom/malinskiy/marathon/config/TestFilterConfiguration$CompositionFilterConfiguration$OPERATION;", "(Ljava/util/List;Lcom/malinskiy/marathon/config/TestFilterConfiguration$CompositionFilterConfiguration$OPERATION;)V", "getFilters", "()Ljava/util/List;", "getOp", "()Lcom/malinskiy/marathon/config/TestFilterConfiguration$CompositionFilterConfiguration$OPERATION;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "validate", "", "OPERATION", "configuration"})
    public static final class CompositionFilterConfiguration
    extends TestFilterConfiguration {
        @NotNull
        private final List<TestFilterConfiguration> filters;
        @NotNull
        private final OPERATION op;

        public CompositionFilterConfiguration(@JsonProperty(value="filters") @NotNull List<? extends TestFilterConfiguration> filters, @JsonProperty(value="op") @NotNull OPERATION op) {
            Intrinsics.checkNotNullParameter(filters, (String)"filters");
            Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
            super(null);
            this.filters = filters;
            this.op = op;
        }

        @NotNull
        public final List<TestFilterConfiguration> getFilters() {
            return this.filters;
        }

        @NotNull
        public final OPERATION getOp() {
            return this.op;
        }

        @Override
        public void validate() {
            Iterable $this$forEach$iv = this.filters;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TestFilterConfiguration it = (TestFilterConfiguration)element$iv;
                boolean bl = false;
                it.validate();
            }
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof CompositionFilterConfiguration)) {
                return false;
            }
            Collection collection = this.filters;
            boolean bl = false;
            int n = collection.size();
            collection = ((CompositionFilterConfiguration)other).filters;
            bl = false;
            if (n != collection.size()) {
                return false;
            }
            if (this.op != ((CompositionFilterConfiguration)other).op) {
                return false;
            }
            Iterable $this$forEach$iv = this.filters;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TestFilterConfiguration it = (TestFilterConfiguration)element$iv;
                boolean bl2 = false;
                if (((CompositionFilterConfiguration)other).getFilters().contains(it)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return ((Object)this.filters).hashCode() + this.op.hashCode();
        }

        @NotNull
        public final List<TestFilterConfiguration> component1() {
            return this.filters;
        }

        @NotNull
        public final OPERATION component2() {
            return this.op;
        }

        @NotNull
        public final CompositionFilterConfiguration copy(@JsonProperty(value="filters") @NotNull List<? extends TestFilterConfiguration> filters, @JsonProperty(value="op") @NotNull OPERATION op) {
            Intrinsics.checkNotNullParameter(filters, (String)"filters");
            Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
            return new CompositionFilterConfiguration(filters, op);
        }

        public static /* synthetic */ CompositionFilterConfiguration copy$default(CompositionFilterConfiguration compositionFilterConfiguration, List list, OPERATION oPERATION, int n, Object object) {
            if ((n & 1) != 0) {
                list = compositionFilterConfiguration.filters;
            }
            if ((n & 2) != 0) {
                oPERATION = compositionFilterConfiguration.op;
            }
            return compositionFilterConfiguration.copy(list, oPERATION);
        }

        @NotNull
        public String toString() {
            return "CompositionFilterConfiguration(filters=" + this.filters + ", op=" + (Object)((Object)this.op) + ')';
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration$CompositionFilterConfiguration$OPERATION;", "", "(Ljava/lang/String;I)V", "UNION", "INTERSECTION", "SUBTRACT", "configuration"})
        public static final class OPERATION
        extends Enum<OPERATION> {
            public static final /* enum */ OPERATION UNION = new OPERATION();
            public static final /* enum */ OPERATION INTERSECTION = new OPERATION();
            public static final /* enum */ OPERATION SUBTRACT = new OPERATION();
            private static final /* synthetic */ OPERATION[] $VALUES;

            public static OPERATION[] values() {
                return (OPERATION[])$VALUES.clone();
            }

            public static OPERATION valueOf(String value) {
                return Enum.valueOf(OPERATION.class, value);
            }

            static {
                $VALUES = oPERATIONArray = new OPERATION[]{OPERATION.UNION, OPERATION.INTERSECTION, OPERATION.SUBTRACT};
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0096\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration$AllureFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration;", "()V", "equals", "", "other", "", "hashCode", "", "validate", "", "configuration"})
    public static final class AllureFilterConfiguration
    extends TestFilterConfiguration {
        @NotNull
        public static final AllureFilterConfiguration INSTANCE = new AllureFilterConfiguration();

        private AllureFilterConfiguration() {
            super(null);
        }

        @Override
        public void validate() {
        }

        public boolean equals(@Nullable Object other) {
            return super.equals(other);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

