/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.marathon.config.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.fasterxml.jackson.module.kotlin.SingletonSupport;
import com.malinskiy.marathon.config.Configuration;
import com.malinskiy.marathon.config.environment.EnvironmentReader;
import com.malinskiy.marathon.config.environment.SystemEnvironmentReader;
import com.malinskiy.marathon.config.exceptions.ConfigurationException;
import com.malinskiy.marathon.config.serialization.ConfigurationFactoryKt;
import com.malinskiy.marathon.config.serialization.time.InstantTimeProviderImpl;
import com.malinskiy.marathon.config.serialization.yaml.DerivedDataFileListProvider;
import com.malinskiy.marathon.config.serialization.yaml.FileListProvider;
import com.malinskiy.marathon.config.serialization.yaml.SerializeModule;
import com.malinskiy.marathon.config.vendor.VendorConfiguration;
import java.io.File;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookupFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/malinskiy/marathon/config/serialization/ConfigurationFactory;", "", "marathonfileDir", "Ljava/io/File;", "fileListProvider", "Lcom/malinskiy/marathon/config/serialization/yaml/FileListProvider;", "environmentReader", "Lcom/malinskiy/marathon/config/environment/EnvironmentReader;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "environmentVariableSubstitutor", "Lorg/apache/commons/text/StringSubstitutor;", "(Ljava/io/File;Lcom/malinskiy/marathon/config/serialization/yaml/FileListProvider;Lcom/malinskiy/marathon/config/environment/EnvironmentReader;Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/apache/commons/text/StringSubstitutor;)V", "parse", "Lcom/malinskiy/marathon/config/Configuration;", "marathonfile", "serialize", "", "configuration"})
public final class ConfigurationFactory {
    @NotNull
    private final File marathonfileDir;
    @NotNull
    private final FileListProvider fileListProvider;
    @NotNull
    private final EnvironmentReader environmentReader;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private final StringSubstitutor environmentVariableSubstitutor;

    public ConfigurationFactory(@NotNull File marathonfileDir, @NotNull FileListProvider fileListProvider, @NotNull EnvironmentReader environmentReader, @NotNull ObjectMapper mapper, @NotNull StringSubstitutor environmentVariableSubstitutor) {
        Intrinsics.checkNotNullParameter((Object)marathonfileDir, (String)"marathonfileDir");
        Intrinsics.checkNotNullParameter((Object)fileListProvider, (String)"fileListProvider");
        Intrinsics.checkNotNullParameter((Object)environmentReader, (String)"environmentReader");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)environmentVariableSubstitutor, (String)"environmentVariableSubstitutor");
        this.marathonfileDir = marathonfileDir;
        this.fileListProvider = fileListProvider;
        this.environmentReader = environmentReader;
        this.mapper = mapper;
        this.environmentVariableSubstitutor = environmentVariableSubstitutor;
    }

    public /* synthetic */ ConfigurationFactory(File file, FileListProvider fileListProvider, EnvironmentReader environmentReader, ObjectMapper objectMapper, StringSubstitutor stringSubstitutor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            fileListProvider = DerivedDataFileListProvider.INSTANCE;
        }
        if ((n & 4) != 0) {
            environmentReader = new SystemEnvironmentReader(null, 1, null);
        }
        if ((n & 8) != 0) {
            ObjectMapper objectMapper2 = new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID));
            boolean bl = false;
            boolean bl2 = false;
            ObjectMapper $this$_init__u24lambda_u2d0 = objectMapper2;
            boolean bl3 = false;
            $this$_init__u24lambda_u2d0.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            $this$_init__u24lambda_u2d0.registerModule((Module)new SerializeModule(new InstantTimeProviderImpl(), environmentReader, file, fileListProvider));
            $this$_init__u24lambda_u2d0.registerModule((Module)new KotlinModule(0, false, false, false, SingletonSupport.CANONICALIZE, false, 47, null));
            $this$_init__u24lambda_u2d0.registerModule((Module)new JavaTimeModule());
            objectMapper = objectMapper2;
        }
        if ((n & 0x10) != 0) {
            stringSubstitutor = new StringSubstitutor(StringLookupFactory.INSTANCE.environmentVariableStringLookup());
        }
        this(file, fileListProvider, environmentReader, objectMapper, stringSubstitutor);
    }

    @NotNull
    public final Configuration parse(@NotNull File marathonfile) {
        Intrinsics.checkNotNullParameter((Object)marathonfile, (String)"marathonfile");
        String configWithEnvironmentVariablesReplaced = this.environmentVariableSubstitutor.replace(FilesKt.readText$default((File)marathonfile, null, (int)1, null));
        try {
            VendorConfiguration vendorConfiguration;
            Configuration configuration = (Configuration)this.mapper.readValue(configWithEnvironmentVariablesReplaced, Configuration.class);
            VendorConfiguration vendorConfiguration2 = configuration.getVendorConfiguration();
            if (vendorConfiguration2 instanceof VendorConfiguration.AndroidConfiguration) {
                VendorConfiguration.AndroidConfiguration androidConfiguration;
                if (((VendorConfiguration.AndroidConfiguration)configuration.getVendorConfiguration()).getAndroidSdk() == null) {
                    File file = this.environmentReader.read().getAndroidSdk();
                    if (file == null) {
                        throw new ConfigurationException("No android SDK path specified");
                    }
                    File androidSdk = file;
                    androidConfiguration = VendorConfiguration.AndroidConfiguration.copy$default((VendorConfiguration.AndroidConfiguration)configuration.getVendorConfiguration(), null, androidSdk, null, null, null, null, false, null, false, false, 0, null, null, null, 0L, null, null, null, null, null, null, null, 0x3FFFFD, null);
                } else {
                    androidConfiguration = (VendorConfiguration.AndroidConfiguration)configuration.getVendorConfiguration();
                }
                vendorConfiguration = androidConfiguration;
            } else if (vendorConfiguration2 instanceof VendorConfiguration.IOSConfiguration) {
                File file;
                File $this$firstOrNull$iv;
                File resolvedDerivedDataDir = FilesKt.resolve((File)this.marathonfileDir, (File)((VendorConfiguration.IOSConfiguration)configuration.getVendorConfiguration()).getDerivedDataDir());
                File file2 = ((VendorConfiguration.IOSConfiguration)configuration.getVendorConfiguration()).getXctestrunPath();
                if (file2 == null) {
                    Object v2;
                    block15: {
                        Iterable<File> iterable = this.fileListProvider.fileList(resolvedDerivedDataDir);
                        boolean $i$f$firstOrNull = false;
                        Iterator iterator = $this$firstOrNull$iv.iterator();
                        while (iterator.hasNext()) {
                            Object element$iv = iterator.next();
                            File it = (File)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"xctestrun")) continue;
                            v2 = element$iv;
                            break block15;
                        }
                        v2 = null;
                    }
                    File file3 = v2;
                    if (file3 == null) {
                        throw new ConfigurationException("Unable to find an xctestrun file in derived data folder");
                    }
                    file = file3;
                } else {
                    file = ConfigurationFactoryKt.access$resolveAgainst(file2, this.marathonfileDir);
                }
                File finalXCTestRunPath = file;
                File optionalSourceRoot = ConfigurationFactoryKt.access$resolveAgainst(((VendorConfiguration.IOSConfiguration)configuration.getVendorConfiguration()).getSourceRoot(), this.marathonfileDir);
                $this$firstOrNull$iv = ((VendorConfiguration.IOSConfiguration)configuration.getVendorConfiguration()).getDevicesFile();
                File optionalDevices = $this$firstOrNull$iv == null ? FilesKt.resolve((File)this.marathonfileDir, (String)"Marathondevices") : ConfigurationFactoryKt.access$resolveAgainst($this$firstOrNull$iv, this.marathonfileDir);
                File file4 = ((VendorConfiguration.IOSConfiguration)configuration.getVendorConfiguration()).getKnownHostsPath();
                File optionalKnownHostsPath = file4 == null ? null : ConfigurationFactoryKt.access$resolveAgainst(file4, this.marathonfileDir);
                vendorConfiguration = VendorConfiguration.IOSConfiguration.copy$default((VendorConfiguration.IOSConfiguration)configuration.getVendorConfiguration(), resolvedDerivedDataDir, finalXCTestRunPath, null, null, optionalKnownHostsPath, null, optionalSourceRoot, false, false, false, false, 0L, optionalDevices, 4012, null);
            } else if (Intrinsics.areEqual((Object)vendorConfiguration2, (Object)VendorConfiguration.StubVendorConfiguration.INSTANCE)) {
                vendorConfiguration = configuration.getVendorConfiguration();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            VendorConfiguration vendorConfiguration3 = vendorConfiguration;
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"configuration");
            return Configuration.copy$default(configuration, null, null, null, null, null, null, null, null, null, null, null, false, false, false, false, 0, null, null, null, 0L, 0L, false, null, vendorConfiguration3, false, 0L, 0x37FFFFF, null);
        }
        catch (JsonProcessingException e) {
            throw new ConfigurationException(Intrinsics.stringPlus((String)"Error parsing config file ", (Object)marathonfile.getAbsolutePath()), e);
        }
    }

    @NotNull
    public final String serialize(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        String string = this.mapper.writeValueAsString((Object)configuration);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mapper.writeValueAsString(configuration)");
        return string;
    }
}

