/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.marathon.config.serialization.yaml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/malinskiy/marathon/config/serialization/yaml/FileDeserializer;", "Lcom/fasterxml/jackson/databind/deser/std/StdDeserializer;", "Ljava/io/File;", "marathonfileDir", "(Ljava/io/File;)V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "configuration"})
public final class FileDeserializer
extends StdDeserializer<File> {
    @NotNull
    private final File marathonfileDir;

    public FileDeserializer(@NotNull File marathonfileDir) {
        Intrinsics.checkNotNullParameter((Object)marathonfileDir, (String)"marathonfileDir");
        super(File.class);
        this.marathonfileDir = marathonfileDir;
    }

    @NotNull
    public File deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        File file;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        Path path = Paths.get(p.getValueAsString(), new String[0]);
        if (path.isAbsolute()) {
            File file2 = path.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"{\n            path.toFile()\n        }");
            file = file2;
        } else {
            File file3 = new File(this.marathonfileDir, p.getValueAsString()).getCanonicalFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"{\n            File(marathonfileDir, p.valueAsString).canonicalFile\n        }");
            file = file3;
        }
        return file;
    }
}

