/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.marathon.config.serialization.yaml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.malinskiy.marathon.config.exceptions.ConfigurationException;
import com.malinskiy.marathon.config.serialization.time.InstantTimeProvider;
import com.malinskiy.marathon.config.serialization.yaml.ProbabilityBasedFlakinessStrategyConfigurationDeserializerKt;
import com.malinskiy.marathon.config.strategy.FlakinessStrategyConfiguration;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/malinskiy/marathon/config/serialization/yaml/ProbabilityBasedFlakinessStrategyConfigurationDeserializer;", "Lcom/fasterxml/jackson/databind/deser/std/StdDeserializer;", "Lcom/malinskiy/marathon/config/strategy/FlakinessStrategyConfiguration$ProbabilityBasedFlakinessStrategyConfiguration;", "instantTimeProvider", "Lcom/malinskiy/marathon/config/serialization/time/InstantTimeProvider;", "(Lcom/malinskiy/marathon/config/serialization/time/InstantTimeProvider;)V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "configuration"})
public final class ProbabilityBasedFlakinessStrategyConfigurationDeserializer
extends StdDeserializer<FlakinessStrategyConfiguration.ProbabilityBasedFlakinessStrategyConfiguration> {
    @NotNull
    private final InstantTimeProvider instantTimeProvider;

    public ProbabilityBasedFlakinessStrategyConfigurationDeserializer(@NotNull InstantTimeProvider instantTimeProvider) {
        Intrinsics.checkNotNullParameter((Object)instantTimeProvider, (String)"instantTimeProvider");
        super(FlakinessStrategyConfiguration.ProbabilityBasedFlakinessStrategyConfiguration.class);
        this.instantTimeProvider = instantTimeProvider;
    }

    @NotNull
    public FlakinessStrategyConfiguration.ProbabilityBasedFlakinessStrategyConfiguration deserialize(@Nullable JsonParser p, @Nullable DeserializationContext ctxt) {
        Instant instant;
        Double d;
        ObjectCodec objectCodec;
        JsonParser jsonParser = p;
        ObjectCodec objectCodec2 = objectCodec = jsonParser == null ? null : jsonParser.getCodec();
        if (objectCodec == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.fasterxml.jackson.databind.ObjectMapper");
        }
        ObjectMapper codec = (ObjectMapper)objectCodec;
        jsonParser = (JsonNode)codec.readTree(p);
        if (jsonParser == null) {
            throw new ConfigurationException("Invalid sorting strategy");
        }
        JsonParser node = jsonParser;
        JsonNode jsonNode = node.findValue("minSuccessRate");
        Double d2 = d = jsonNode == null ? null : Double.valueOf(jsonNode.asDouble());
        if (d == null) {
            throw new ConfigurationException("Missing minimum success rate value");
        }
        double minSuccessRate = d;
        JsonNode jsonNode2 = node.findValue("maxCount");
        Integer n = jsonNode = jsonNode2 == null ? null : Integer.valueOf(jsonNode2.asInt());
        if (jsonNode == null) {
            throw new ConfigurationException("Missing maximum count value");
        }
        int maxCount = jsonNode.intValue();
        jsonNode2 = node.findValue("timeLimit");
        if (jsonNode2 == null) {
            throw new ConfigurationException("Missing time limit value");
        }
        JsonNode timeLimitValue = jsonNode2;
        Instant instant2 = (Instant)ProbabilityBasedFlakinessStrategyConfigurationDeserializerKt.access$treeToValueOrNull(codec, (TreeNode)timeLimitValue, Instant.class);
        if (instant2 == null) {
            Duration duration = (Duration)ProbabilityBasedFlakinessStrategyConfigurationDeserializerKt.access$treeToValueOrNull(codec, (TreeNode)timeLimitValue, Duration.class);
            if (duration == null) {
                throw new ConfigurationException("Unable to deserialize " + timeLimitValue + " into Instant");
            }
            instant = ProbabilityBasedFlakinessStrategyConfigurationDeserializerKt.access$addToInstant(duration, this.instantTimeProvider.referenceTime());
        } else {
            instant = instant2;
        }
        Instant instant3 = instant;
        return new FlakinessStrategyConfiguration.ProbabilityBasedFlakinessStrategyConfiguration(minSuccessRate, maxCount, instant3);
    }
}

