/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.marathon.config.serialization.yaml;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.malinskiy.marathon.config.AnalyticsConfiguration;
import com.malinskiy.marathon.config.environment.EnvironmentReader;
import com.malinskiy.marathon.config.serialization.time.InstantTimeProvider;
import com.malinskiy.marathon.config.serialization.yaml.ExecutionTimeSortingStrategyConfigurationDeserializer;
import com.malinskiy.marathon.config.serialization.yaml.FileDeserializer;
import com.malinskiy.marathon.config.serialization.yaml.FileListProvider;
import com.malinskiy.marathon.config.serialization.yaml.FixedSizeBatchingStrategyConfigurationDeserializer;
import com.malinskiy.marathon.config.serialization.yaml.GraphiteConfigurationDeserializer;
import com.malinskiy.marathon.config.serialization.yaml.InfluxDbConfigurationDeserializer;
import com.malinskiy.marathon.config.serialization.yaml.ProbabilityBasedFlakinessStrategyConfigurationDeserializer;
import com.malinskiy.marathon.config.serialization.yaml.RegexSerializer;
import com.malinskiy.marathon.config.serialization.yaml.RetentionPolicyConfigurationDeserializer;
import com.malinskiy.marathon.config.serialization.yaml.VendorConfigurationDeserializer;
import com.malinskiy.marathon.config.strategy.BatchingStrategyConfiguration;
import com.malinskiy.marathon.config.strategy.FlakinessStrategyConfiguration;
import com.malinskiy.marathon.config.strategy.SortingStrategyConfiguration;
import com.malinskiy.marathon.config.vendor.VendorConfiguration;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/malinskiy/marathon/config/serialization/yaml/SerializeModule;", "Lcom/fasterxml/jackson/databind/module/SimpleModule;", "instantTimeProvider", "Lcom/malinskiy/marathon/config/serialization/time/InstantTimeProvider;", "environmentReader", "Lcom/malinskiy/marathon/config/environment/EnvironmentReader;", "marathonfileDir", "Ljava/io/File;", "fileListProvider", "Lcom/malinskiy/marathon/config/serialization/yaml/FileListProvider;", "(Lcom/malinskiy/marathon/config/serialization/time/InstantTimeProvider;Lcom/malinskiy/marathon/config/environment/EnvironmentReader;Ljava/io/File;Lcom/malinskiy/marathon/config/serialization/yaml/FileListProvider;)V", "configuration"})
public final class SerializeModule
extends SimpleModule {
    public SerializeModule(@NotNull InstantTimeProvider instantTimeProvider, @NotNull EnvironmentReader environmentReader, @NotNull File marathonfileDir, @NotNull FileListProvider fileListProvider) {
        Intrinsics.checkNotNullParameter((Object)instantTimeProvider, (String)"instantTimeProvider");
        Intrinsics.checkNotNullParameter((Object)environmentReader, (String)"environmentReader");
        Intrinsics.checkNotNullParameter((Object)marathonfileDir, (String)"marathonfileDir");
        Intrinsics.checkNotNullParameter((Object)fileListProvider, (String)"fileListProvider");
        this.addDeserializer(AnalyticsConfiguration.InfluxDbConfiguration.class, (JsonDeserializer)new InfluxDbConfigurationDeserializer());
        this.addDeserializer(AnalyticsConfiguration.GraphiteConfiguration.class, (JsonDeserializer)new GraphiteConfigurationDeserializer());
        this.addDeserializer(AnalyticsConfiguration.InfluxDbConfiguration.RetentionPolicyConfiguration.class, (JsonDeserializer)new RetentionPolicyConfigurationDeserializer());
        this.addDeserializer(SortingStrategyConfiguration.ExecutionTimeSortingStrategyConfiguration.class, (JsonDeserializer)new ExecutionTimeSortingStrategyConfigurationDeserializer(instantTimeProvider));
        this.addDeserializer(FlakinessStrategyConfiguration.ProbabilityBasedFlakinessStrategyConfiguration.class, (JsonDeserializer)new ProbabilityBasedFlakinessStrategyConfigurationDeserializer(instantTimeProvider));
        this.addDeserializer(BatchingStrategyConfiguration.FixedSizeBatchingStrategyConfiguration.class, (JsonDeserializer)new FixedSizeBatchingStrategyConfigurationDeserializer(instantTimeProvider));
        this.addSerializer(Regex.class, (JsonSerializer)new RegexSerializer());
        this.addDeserializer(File.class, (JsonDeserializer)new FileDeserializer(marathonfileDir));
        this.addDeserializer(VendorConfiguration.class, (JsonDeserializer)new VendorConfigurationDeserializer(marathonfileDir, environmentReader, fileListProvider));
    }
}

