/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.marathon.config.serialization.yaml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.malinskiy.marathon.config.environment.EnvironmentReader;
import com.malinskiy.marathon.config.exceptions.ConfigurationException;
import com.malinskiy.marathon.config.serialization.yaml.FileListProvider;
import com.malinskiy.marathon.config.serialization.yaml.VendorConfigurationDeserializerKt;
import com.malinskiy.marathon.config.vendor.VendorConfiguration;
import java.io.File;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/malinskiy/marathon/config/serialization/yaml/VendorConfigurationDeserializer;", "Lcom/fasterxml/jackson/databind/deser/std/StdDeserializer;", "Lcom/malinskiy/marathon/config/vendor/VendorConfiguration;", "marathonfileDir", "Ljava/io/File;", "environmentReader", "Lcom/malinskiy/marathon/config/environment/EnvironmentReader;", "fileListProvider", "Lcom/malinskiy/marathon/config/serialization/yaml/FileListProvider;", "(Ljava/io/File;Lcom/malinskiy/marathon/config/environment/EnvironmentReader;Lcom/malinskiy/marathon/config/serialization/yaml/FileListProvider;)V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "configuration"})
public final class VendorConfigurationDeserializer
extends StdDeserializer<VendorConfiguration> {
    @NotNull
    private final File marathonfileDir;
    @NotNull
    private final EnvironmentReader environmentReader;
    @NotNull
    private final FileListProvider fileListProvider;

    public VendorConfigurationDeserializer(@NotNull File marathonfileDir, @NotNull EnvironmentReader environmentReader, @NotNull FileListProvider fileListProvider) {
        Intrinsics.checkNotNullParameter((Object)marathonfileDir, (String)"marathonfileDir");
        Intrinsics.checkNotNullParameter((Object)environmentReader, (String)"environmentReader");
        Intrinsics.checkNotNullParameter((Object)fileListProvider, (String)"fileListProvider");
        super(VendorConfiguration.class);
        this.marathonfileDir = marathonfileDir;
        this.environmentReader = environmentReader;
        this.fileListProvider = fileListProvider;
    }

    @NotNull
    public VendorConfiguration deserialize(@Nullable JsonParser p, @Nullable DeserializationContext ctxt) {
        VendorConfiguration vendorConfiguration;
        ObjectCodec objectCodec;
        JsonParser jsonParser = p;
        ObjectCodec objectCodec2 = objectCodec = jsonParser == null ? null : jsonParser.getCodec();
        if (objectCodec == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.fasterxml.jackson.databind.ObjectMapper");
        }
        ObjectMapper codec = (ObjectMapper)objectCodec;
        jsonParser = (JsonNode)codec.readTree(p);
        if (jsonParser == null) {
            throw new ConfigurationException("Missing vendor configuration");
        }
        JsonParser node = jsonParser;
        String type = node.get("type").asText();
        String string = type;
        if (Intrinsics.areEqual((Object)string, (Object)"iOS")) {
            File file;
            File $this$firstOrNull$iv;
            ((ObjectNode)node).remove("type");
            ObjectMapper $this$treeToValue$iv = codec;
            boolean $i$f$treeToValue22 = false;
            boolean $i$f$jacksonTypeRef2 = false;
            VendorConfiguration.IOSConfiguration iOSConfiguration = (VendorConfiguration.IOSConfiguration)$this$treeToValue$iv.readValue($this$treeToValue$iv.treeAsTokens((TreeNode)node), (TypeReference)new TypeReference<VendorConfiguration.IOSConfiguration>(){});
            if (iOSConfiguration == null) {
                throw new ConfigurationException("Missing vendor configuration");
            }
            VendorConfiguration.IOSConfiguration iosConfiguration = iOSConfiguration;
            File resolvedDerivedDataDir = FilesKt.resolve((File)this.marathonfileDir, (File)iosConfiguration.getDerivedDataDir());
            File $i$f$treeToValue22 = iosConfiguration.getXctestrunPath();
            if ($i$f$treeToValue22 == null) {
                Object v1;
                block15: {
                    Iterable<File> iterable = this.fileListProvider.fileList(resolvedDerivedDataDir);
                    boolean $i$f$firstOrNull = false;
                    Iterator iterator = $this$firstOrNull$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv = iterator.next();
                        File it = (File)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"xctestrun")) continue;
                        v1 = element$iv;
                        break block15;
                    }
                    v1 = null;
                }
                File $i$f$jacksonTypeRef2 = v1;
                if ($i$f$jacksonTypeRef2 == null) {
                    throw new ConfigurationException("Unable to find an xctestrun file in derived data folder");
                }
                file = $i$f$jacksonTypeRef2;
            } else {
                file = VendorConfigurationDeserializerKt.access$resolveAgainst($i$f$treeToValue22, this.marathonfileDir);
            }
            File finalXCTestRunPath = file;
            File optionalSourceRoot = VendorConfigurationDeserializerKt.access$resolveAgainst(iosConfiguration.getSourceRoot(), this.marathonfileDir);
            $this$firstOrNull$iv = iosConfiguration.getDevicesFile();
            File optionalDevices = $this$firstOrNull$iv == null ? FilesKt.resolve((File)this.marathonfileDir, (String)"Marathondevices") : VendorConfigurationDeserializerKt.access$resolveAgainst($this$firstOrNull$iv, this.marathonfileDir);
            File file2 = iosConfiguration.getKnownHostsPath();
            File optionalKnownHostsPath = file2 == null ? null : VendorConfigurationDeserializerKt.access$resolveAgainst(file2, this.marathonfileDir);
            vendorConfiguration = VendorConfiguration.IOSConfiguration.copy$default(iosConfiguration, resolvedDerivedDataDir, finalXCTestRunPath, null, null, optionalKnownHostsPath, null, optionalSourceRoot, false, false, false, false, 0L, optionalDevices, 4012, null);
        } else if (Intrinsics.areEqual((Object)string, (Object)"Android")) {
            VendorConfiguration.AndroidConfiguration androidConfiguration;
            ((ObjectNode)node).remove("type");
            ObjectMapper $this$treeToValue$iv = codec;
            boolean $i$f$treeToValue = false;
            boolean $i$f$jacksonTypeRef = false;
            VendorConfiguration.AndroidConfiguration resolvedDerivedDataDir = (VendorConfiguration.AndroidConfiguration)$this$treeToValue$iv.readValue($this$treeToValue$iv.treeAsTokens((TreeNode)node), (TypeReference)new TypeReference<VendorConfiguration.AndroidConfiguration>(){});
            if (resolvedDerivedDataDir == null) {
                throw new ConfigurationException("Missing vendor configuration");
            }
            VendorConfiguration.AndroidConfiguration androidConfiguration2 = resolvedDerivedDataDir;
            if (androidConfiguration2.getAndroidSdk() == null) {
                File file = this.environmentReader.read().getAndroidSdk();
                if (file == null) {
                    throw new ConfigurationException("No android SDK path specified");
                }
                File androidSdk = file;
                androidConfiguration = VendorConfiguration.AndroidConfiguration.copy$default(androidConfiguration2, null, androidSdk, null, null, null, null, false, null, false, false, 0, null, null, null, 0L, null, null, null, null, null, null, null, 0x3FFFFD, null);
            } else {
                androidConfiguration = androidConfiguration2;
            }
            vendorConfiguration = androidConfiguration;
        } else {
            throw new ConfigurationException("Unrecognized vendor type " + type + ". Valid options are Android and iOS");
        }
        return vendorConfiguration;
    }
}

