/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.marathon.config.strategy;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ExecutionTimeSortingStrategyConfiguration.class, name="execution-time"), @JsonSubTypes.Type(value=NoSortingStrategyConfiguration.class, name="no-sorting"), @JsonSubTypes.Type(value=RandomOrderStrategyConfiguration.class, name="random-order"), @JsonSubTypes.Type(value=SuccessRateSortingStrategyConfiguration.class, name="success-rate")})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lcom/malinskiy/marathon/config/strategy/SortingStrategyConfiguration;", "", "()V", "ExecutionTimeSortingStrategyConfiguration", "NoSortingStrategyConfiguration", "RandomOrderStrategyConfiguration", "SuccessRateSortingStrategyConfiguration", "Lcom/malinskiy/marathon/config/strategy/SortingStrategyConfiguration$ExecutionTimeSortingStrategyConfiguration;", "Lcom/malinskiy/marathon/config/strategy/SortingStrategyConfiguration$NoSortingStrategyConfiguration;", "Lcom/malinskiy/marathon/config/strategy/SortingStrategyConfiguration$RandomOrderStrategyConfiguration;", "Lcom/malinskiy/marathon/config/strategy/SortingStrategyConfiguration$SuccessRateSortingStrategyConfiguration;", "configuration"})
public abstract class SortingStrategyConfiguration {
    private SortingStrategyConfiguration() {
    }

    public /* synthetic */ SortingStrategyConfiguration(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/malinskiy/marathon/config/strategy/SortingStrategyConfiguration$ExecutionTimeSortingStrategyConfiguration;", "Lcom/malinskiy/marathon/config/strategy/SortingStrategyConfiguration;", "percentile", "", "timeLimit", "Ljava/time/Instant;", "(DLjava/time/Instant;)V", "getPercentile", "()D", "getTimeLimit", "()Ljava/time/Instant;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "configuration"})
    public static final class ExecutionTimeSortingStrategyConfiguration
    extends SortingStrategyConfiguration {
        private final double percentile;
        @NotNull
        private final Instant timeLimit;

        public ExecutionTimeSortingStrategyConfiguration(double percentile, @NotNull Instant timeLimit) {
            Intrinsics.checkNotNullParameter((Object)timeLimit, (String)"timeLimit");
            super(null);
            this.percentile = percentile;
            this.timeLimit = timeLimit;
        }

        public final double getPercentile() {
            return this.percentile;
        }

        @NotNull
        public final Instant getTimeLimit() {
            return this.timeLimit;
        }

        public final double component1() {
            return this.percentile;
        }

        @NotNull
        public final Instant component2() {
            return this.timeLimit;
        }

        @NotNull
        public final ExecutionTimeSortingStrategyConfiguration copy(double percentile, @NotNull Instant timeLimit) {
            Intrinsics.checkNotNullParameter((Object)timeLimit, (String)"timeLimit");
            return new ExecutionTimeSortingStrategyConfiguration(percentile, timeLimit);
        }

        public static /* synthetic */ ExecutionTimeSortingStrategyConfiguration copy$default(ExecutionTimeSortingStrategyConfiguration executionTimeSortingStrategyConfiguration, double d, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                d = executionTimeSortingStrategyConfiguration.percentile;
            }
            if ((n & 2) != 0) {
                instant = executionTimeSortingStrategyConfiguration.timeLimit;
            }
            return executionTimeSortingStrategyConfiguration.copy(d, instant);
        }

        @NotNull
        public String toString() {
            return "ExecutionTimeSortingStrategyConfiguration(percentile=" + this.percentile + ", timeLimit=" + this.timeLimit + ')';
        }

        public int hashCode() {
            int result = Double.hashCode(this.percentile);
            result = result * 31 + this.timeLimit.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExecutionTimeSortingStrategyConfiguration)) {
                return false;
            }
            ExecutionTimeSortingStrategyConfiguration executionTimeSortingStrategyConfiguration = (ExecutionTimeSortingStrategyConfiguration)other;
            if (!Intrinsics.areEqual((Object)this.percentile, (Object)executionTimeSortingStrategyConfiguration.percentile)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.timeLimit, (Object)executionTimeSortingStrategyConfiguration.timeLimit);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/malinskiy/marathon/config/strategy/SortingStrategyConfiguration$NoSortingStrategyConfiguration;", "Lcom/malinskiy/marathon/config/strategy/SortingStrategyConfiguration;", "()V", "configuration"})
    public static final class NoSortingStrategyConfiguration
    extends SortingStrategyConfiguration {
        @NotNull
        public static final NoSortingStrategyConfiguration INSTANCE = new NoSortingStrategyConfiguration();

        private NoSortingStrategyConfiguration() {
            super(null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/malinskiy/marathon/config/strategy/SortingStrategyConfiguration$RandomOrderStrategyConfiguration;", "Lcom/malinskiy/marathon/config/strategy/SortingStrategyConfiguration;", "()V", "configuration"})
    public static final class RandomOrderStrategyConfiguration
    extends SortingStrategyConfiguration {
        @NotNull
        public static final RandomOrderStrategyConfiguration INSTANCE = new RandomOrderStrategyConfiguration();

        private RandomOrderStrategyConfiguration() {
            super(null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/malinskiy/marathon/config/strategy/SortingStrategyConfiguration$SuccessRateSortingStrategyConfiguration;", "Lcom/malinskiy/marathon/config/strategy/SortingStrategyConfiguration;", "timeLimit", "Ljava/time/Instant;", "ascending", "", "(Ljava/time/Instant;Z)V", "getAscending", "()Z", "getTimeLimit", "()Ljava/time/Instant;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "configuration"})
    public static final class SuccessRateSortingStrategyConfiguration
    extends SortingStrategyConfiguration {
        @NotNull
        private final Instant timeLimit;
        private final boolean ascending;

        public SuccessRateSortingStrategyConfiguration(@JsonProperty(value="timeLimit") @NotNull Instant timeLimit, @JsonProperty(value="ascending") boolean ascending) {
            Intrinsics.checkNotNullParameter((Object)timeLimit, (String)"timeLimit");
            super(null);
            this.timeLimit = timeLimit;
            this.ascending = ascending;
        }

        public /* synthetic */ SuccessRateSortingStrategyConfiguration(Instant instant, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(instant, bl);
        }

        @NotNull
        public final Instant getTimeLimit() {
            return this.timeLimit;
        }

        public final boolean getAscending() {
            return this.ascending;
        }

        @NotNull
        public final Instant component1() {
            return this.timeLimit;
        }

        public final boolean component2() {
            return this.ascending;
        }

        @NotNull
        public final SuccessRateSortingStrategyConfiguration copy(@JsonProperty(value="timeLimit") @NotNull Instant timeLimit, @JsonProperty(value="ascending") boolean ascending) {
            Intrinsics.checkNotNullParameter((Object)timeLimit, (String)"timeLimit");
            return new SuccessRateSortingStrategyConfiguration(timeLimit, ascending);
        }

        public static /* synthetic */ SuccessRateSortingStrategyConfiguration copy$default(SuccessRateSortingStrategyConfiguration successRateSortingStrategyConfiguration, Instant instant, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                instant = successRateSortingStrategyConfiguration.timeLimit;
            }
            if ((n & 2) != 0) {
                bl = successRateSortingStrategyConfiguration.ascending;
            }
            return successRateSortingStrategyConfiguration.copy(instant, bl);
        }

        @NotNull
        public String toString() {
            return "SuccessRateSortingStrategyConfiguration(timeLimit=" + this.timeLimit + ", ascending=" + this.ascending + ')';
        }

        public int hashCode() {
            int result = this.timeLimit.hashCode();
            int n = this.ascending ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SuccessRateSortingStrategyConfiguration)) {
                return false;
            }
            SuccessRateSortingStrategyConfiguration successRateSortingStrategyConfiguration = (SuccessRateSortingStrategyConfiguration)other;
            if (!Intrinsics.areEqual((Object)this.timeLimit, (Object)successRateSortingStrategyConfiguration.timeLimit)) {
                return false;
            }
            return this.ascending == successRateSortingStrategyConfiguration.ascending;
        }
    }
}

