/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.utils;

import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.io.DirectoryScanner;

public class MavenArtifactUtils {
    private static final String[] ARTIFACT_EXTENSIONS = new String[]{"jar"};
    private static final String ARTIFACT_NOT_SUPPORTED = "Target file does not exist or is not executable, please check the configuration.";
    private static final String MULTI_ARTIFACT = "Multiple artifacts(%s) could be deployed, please specify the target artifact in plugin configurations.";

    @Nonnull
    public static Collection<File> getArtifactFiles(MavenProject project) {
        String targetFolder = project.getBuild().getDirectory();
        File directory = new File(targetFolder);
        if (!directory.isDirectory()) {
            return new ArrayList<File>();
        }
        return FileUtils.listFiles((File)directory, (String[])ARTIFACT_EXTENSIONS, (boolean)true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean isExecutableJar(File file) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            boolean bl;
            try (JarInputStream jarInputStream = new JarInputStream(fileInputStream);){
                Manifest manifest = jarInputStream.getManifest();
                bl = Optional.ofNullable(manifest).map(Manifest::getMainAttributes).map(a -> a.getValue("Main-Class")).isPresent();
            }
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static List<File> getArtifacts(@Nullable List<Resource> resources) {
        if (resources != null) {
            return resources.stream().flatMap(r -> MavenArtifactUtils.getArtifacts(r).stream()).collect(Collectors.toList());
        }
        return new ArrayList<File>();
    }

    public static List<File> getArtifacts(Resource resource) {
        if (CollectionUtils.isEmpty((Collection)resource.getIncludes())) {
            return Collections.emptyList();
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(resource.getDirectory());
        directoryScanner.setIncludes(resource.getIncludes().toArray(new String[0]));
        String[] exclude = resource.getExcludes() == null ? new String[]{} : resource.getExcludes().toArray(new String[0]);
        directoryScanner.setExcludes(exclude);
        try {
            directoryScanner.scan();
        }
        catch (IllegalStateException e) {
            AzureMessager.getMessager().warning(String.format("'%s' doesn't exist or isn't a directory", resource.getDirectory()));
            return Collections.emptyList();
        }
        return Arrays.stream(directoryScanner.getIncludedFiles()).map(path -> new File(resource.getDirectory(), (String)path)).collect(Collectors.toList());
    }

    @Nullable
    public static File getExecutableJarFiles(Collection<File> files) throws MojoExecutionException {
        if (files.isEmpty()) {
            return null;
        }
        List executableJars = files.stream().filter(MavenArtifactUtils::isExecutableJar).collect(Collectors.toList());
        if (executableJars.isEmpty()) {
            throw new MojoExecutionException(ARTIFACT_NOT_SUPPORTED);
        }
        if (executableJars.size() > 1) {
            String artifactNameLists = executableJars.stream().map(File::getName).collect(Collectors.joining(","));
            throw new MojoExecutionException(String.format(MULTI_ARTIFACT, artifactNameLists));
        }
        return (File)executableJars.get(0);
    }
}

