/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.maven.common.messager;

import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessage;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenAzureMessager
implements IAzureMessager,
IAzureMessage.ValueDecorator {
    private static final Logger log = LoggerFactory.getLogger(MavenAzureMessager.class);

    public boolean show(IAzureMessage message) {
        switch (message.getType()) {
            case ALERT: 
            case CONFIRM: 
            case WARNING: {
                log.warn(message.getContent());
                return true;
            }
            case ERROR: {
                log.error(message.getContent(), (Throwable)message.getPayload());
                return true;
            }
        }
        log.info(message.getContent());
        return true;
    }

    public String decorateValue(@Nonnull Object p, @Nullable IAzureMessage message) {
        return TextUtils.cyan((String)p.toString());
    }
}

