/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cosmosdb;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.cosmosdb.ConsistencyPolicy;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountKind;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountOfferType;
import com.microsoft.azure.management.cosmosdb.DefaultConsistencyLevel;
import com.microsoft.azure.management.cosmosdb.KeyKind;
import com.microsoft.azure.management.cosmosdb.Location;
import com.microsoft.azure.management.cosmosdb.implementation.CosmosDBManager;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListConnectionStringsResult;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListKeysResult;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.List;
import rx.Observable;

@Fluent
@Beta(value=Beta.SinceVersion.V1_2_0)
public interface CosmosDBAccount
extends GroupableResource<CosmosDBManager, DatabaseAccountInner>,
Refreshable<CosmosDBAccount>,
Updatable<Update> {
    public DatabaseAccountKind kind();

    public String documentEndpoint();

    public DatabaseAccountOfferType databaseAccountOfferType();

    public String ipRangeFilter();

    public ConsistencyPolicy consistencyPolicy();

    public DefaultConsistencyLevel defaultConsistencyLevel();

    public List<Location> writableReplications();

    public List<Location> readableReplications();

    public DatabaseAccountListKeysResult listKeys();

    public Observable<DatabaseAccountListKeysResult> listKeysAsync();

    public DatabaseAccountListConnectionStringsResult listConnectionStrings();

    public Observable<DatabaseAccountListConnectionStringsResult> listConnectionStringsAsync();

    public void regenerateKey(KeyKind var1);

    public Observable<Void> regenerateKeyAsync(KeyKind var1);

    public static interface UpdateStages {

        public static interface WithIpRangeFilter {
            public WithOptionals withIpRangeFilter(String var1);
        }

        public static interface WithConsistencyPolicy {
            public WithOptionals withEventualConsistency();

            public WithOptionals withSessionConsistency();

            public WithOptionals withBoundedStalenessConsistency(int var1, int var2);

            public WithOptionals withStrongConsistency();
        }

        public static interface WithReadLocations
        extends Appliable<CosmosDBAccount> {
            public WithReadLocations withReadReplication(Region var1);

            public WithReadLocations withoutReadReplication(Region var1);
        }

        public static interface WithOptionals
        extends Resource.UpdateWithTags<WithOptionals>,
        Appliable<CosmosDBAccount>,
        WithConsistencyPolicy,
        WithIpRangeFilter {
        }
    }

    public static interface Update
    extends UpdateStages.WithReadLocations,
    UpdateStages.WithOptionals {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<CosmosDBAccount>,
        WithConsistencyPolicy,
        WithReadReplication,
        WithIpRangeFilter {
        }

        public static interface WithReadReplication {
            public WithCreate withReadReplication(Region var1);
        }

        public static interface WithWriteReplication {
            public WithCreate withWriteReplication(Region var1);
        }

        public static interface WithIpRangeFilter {
            public WithCreate withIpRangeFilter(String var1);
        }

        public static interface WithConsistencyPolicy {
            public WithWriteReplication withEventualConsistency();

            public WithWriteReplication withSessionConsistency();

            public WithWriteReplication withBoundedStalenessConsistency(int var1, int var2);

            public WithCreate withStrongConsistency();
        }

        public static interface WithKind {
            public WithConsistencyPolicy withKind(DatabaseAccountKind var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithKind> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithKind,
    DefinitionStages.WithWriteReplication,
    DefinitionStages.WithReadReplication,
    DefinitionStages.WithCreate {
    }
}

