/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.google.common.io.BaseEncoding;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.PasswordCredential;
import com.microsoft.azure.management.graphrbac.implementation.HasCredential;
import com.microsoft.azure.management.graphrbac.implementation.PasswordCredentialInner;
import com.microsoft.azure.management.graphrbac.implementation.ServicePrincipalImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.rest.RestClient;
import java.io.IOException;
import java.io.OutputStream;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import rx.Observable;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.Graph.RBAC.Fluent")
class PasswordCredentialImpl<T>
extends IndexableRefreshableWrapperImpl<PasswordCredential, PasswordCredentialInner>
implements PasswordCredential,
PasswordCredential.Definition<T>,
PasswordCredential.UpdateDefinition<T> {
    private String name;
    private HasCredential<?> parent;
    OutputStream authFile;
    private String subscriptionId;

    PasswordCredentialImpl(PasswordCredentialInner passwordCredential) {
        super((Object)passwordCredential);
        this.name = passwordCredential.customKeyIdentifier() != null && !passwordCredential.customKeyIdentifier().isEmpty() ? new String(BaseEncoding.base64().decode((CharSequence)passwordCredential.customKeyIdentifier())) : passwordCredential.keyId();
    }

    PasswordCredentialImpl(String name, HasCredential<?> parent) {
        super((Object)new PasswordCredentialInner().withCustomKeyIdentifier(BaseEncoding.base64().encode(name.getBytes())).withStartDate(DateTime.now()).withEndDate(DateTime.now().plusYears(1)));
        this.name = name;
        this.parent = parent;
    }

    public Observable<PasswordCredential> refreshAsync() {
        throw new UnsupportedOperationException("Cannot refresh credentials.");
    }

    protected Observable<PasswordCredentialInner> getInnerAsync() {
        throw new UnsupportedOperationException("Cannot refresh credentials.");
    }

    public String id() {
        return ((PasswordCredentialInner)this.inner()).keyId();
    }

    @Override
    public DateTime startDate() {
        return ((PasswordCredentialInner)this.inner()).startDate();
    }

    @Override
    public DateTime endDate() {
        return ((PasswordCredentialInner)this.inner()).endDate();
    }

    @Override
    public String value() {
        return ((PasswordCredentialInner)this.inner()).value();
    }

    public T attach() {
        this.parent.withPasswordCredential(this);
        return (T)this.parent;
    }

    @Override
    public PasswordCredentialImpl<T> withPasswordValue(String password) {
        ((PasswordCredentialInner)this.inner()).withValue(password);
        return this;
    }

    @Override
    public PasswordCredentialImpl<T> withStartDate(DateTime startDate) {
        DateTime original = this.startDate();
        ((PasswordCredentialInner)this.inner()).withStartDate(startDate);
        this.withDuration(Duration.millis((long)(this.endDate().getMillis() - original.getMillis())));
        return this;
    }

    @Override
    public PasswordCredentialImpl<T> withDuration(Duration duration) {
        ((PasswordCredentialInner)this.inner()).withEndDate(this.startDate().plus(duration.getMillis()));
        return this;
    }

    public String name() {
        return this.name;
    }

    @Override
    public PasswordCredentialImpl<T> withAuthFileToExport(OutputStream outputStream) {
        this.authFile = outputStream;
        return this;
    }

    void exportAuthFile(ServicePrincipalImpl servicePrincipal) {
        if (this.authFile == null) {
            return;
        }
        RestClient restClient = servicePrincipal.manager().roleInner().restClient();
        AzureEnvironment environment = null;
        if (restClient.credentials() instanceof AzureTokenCredentials) {
            environment = ((AzureTokenCredentials)restClient.credentials()).environment();
        } else {
            String baseUrl = restClient.retrofit().baseUrl().toString();
            for (AzureEnvironment env : AzureEnvironment.knownEnvironments()) {
                if (!env.resourceManagerEndpoint().toLowerCase().contains(baseUrl.toLowerCase())) continue;
                environment = env;
                break;
            }
            if (environment == null) {
                throw new IllegalArgumentException("Unknown resource manager endpoint " + baseUrl);
            }
        }
        StringBuilder builder = new StringBuilder("{\n");
        builder.append("  ").append(String.format("\"clientId\": \"%s\",", servicePrincipal.applicationId())).append("\n");
        builder.append("  ").append(String.format("\"clientSecret\": \"%s\",", this.value())).append("\n");
        builder.append("  ").append(String.format("\"tenantId\": \"%s\",", servicePrincipal.manager().tenantId())).append("\n");
        builder.append("  ").append(String.format("\"subscriptionId\": \"%s\",", servicePrincipal.assignedSubscription)).append("\n");
        builder.append("  ").append(String.format("\"activeDirectoryEndpointUrl\": \"%s\",", environment.activeDirectoryEndpoint())).append("\n");
        builder.append("  ").append(String.format("\"resourceManagerEndpointUrl\": \"%s\",", environment.resourceManagerEndpoint())).append("\n");
        builder.append("  ").append(String.format("\"activeDirectoryGraphResourceId\": \"%s\",", environment.graphEndpoint())).append("\n");
        builder.append("  ").append(String.format("\"managementEndpointUrl\": \"%s\"", environment.managementEndpoint())).append("\n");
        builder.append("}");
        try {
            this.authFile.write(builder.toString().getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PasswordCredentialImpl<T> withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }
}

