/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.Deployment;
import com.microsoft.azure.management.resources.DeploymentOperation;
import com.microsoft.azure.management.resources.DeploymentOperations;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.microsoft.azure.management.resources.implementation.DeploymentOperationImpl;
import com.microsoft.azure.management.resources.implementation.DeploymentOperationInner;
import com.microsoft.azure.management.resources.implementation.DeploymentOperationsInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import rx.Observable;
import rx.functions.Func1;

final class DeploymentOperationsImpl
extends ReadableWrappersImpl<DeploymentOperation, DeploymentOperationImpl, DeploymentOperationInner>
implements DeploymentOperations {
    private final DeploymentOperationsInner client;
    private final Deployment deployment;

    DeploymentOperationsImpl(DeploymentOperationsInner client, Deployment deployment) {
        this.client = client;
        this.deployment = deployment;
    }

    @Override
    public PagedList<DeploymentOperation> list() {
        return this.wrapList(this.client.listByResourceGroup(this.deployment.resourceGroupName(), this.deployment.name()));
    }

    @Override
    public DeploymentOperation getById(String operationId) {
        return (DeploymentOperation)this.getByIdAsync(operationId).toBlocking().last();
    }

    @Override
    public Observable<DeploymentOperation> getByIdAsync(String operationId) {
        return this.client.getAsync(this.deployment.resourceGroupName(), this.deployment.name(), operationId).map((Func1)new Func1<DeploymentOperationInner, DeploymentOperation>(){

            public DeploymentOperation call(DeploymentOperationInner deploymentOperationInner) {
                return DeploymentOperationsImpl.this.wrapModel(deploymentOperationInner);
            }
        });
    }

    @Override
    public ServiceFuture<DeploymentOperation> getByIdAsync(String id, ServiceCallback<DeploymentOperation> callback) {
        return ServiceFuture.fromBody(this.getByIdAsync(id), callback);
    }

    @Override
    protected DeploymentOperationImpl wrapModel(DeploymentOperationInner inner) {
        if (inner == null) {
            return null;
        }
        return new DeploymentOperationImpl(inner, this.client);
    }

    @Override
    public Observable<DeploymentOperation> listAsync() {
        return this.wrapPageAsync(this.client.listByResourceGroupAsync(this.deployment.resourceGroupName(), this.deployment.name()));
    }
}

