/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.primitives;

import com.microsoft.azure.servicebus.primitives.IllegalConnectionStringFormatException;
import com.microsoft.azure.servicebus.primitives.RetryPolicy;
import com.microsoft.azure.servicebus.primitives.StringUtil;
import com.microsoft.azure.servicebus.primitives.Util;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConnectionStringBuilder {
    private static final String END_POINT_RAW_FORMAT = "amqps://%s";
    private static final String HOSTNAME_CONFIG_NAME = "Hostname";
    private static final String ENDPOINT_CONFIG_NAME = "Endpoint";
    private static final String SHARED_ACCESS_KEY_NAME_CONFIG_NAME = "SharedAccessKeyName";
    private static final String SHARED_ACCESS_KEY_CONFIG_NAME = "SharedAccessKey";
    private static final String SHARED_ACCESS_SIGNATURE_TOKEN_CONFIG_NAME = "SharedAccessSignatureToken";
    private static final String ENTITY_PATH_CONFIG_NAME = "EntityPath";
    private static final String OPERATION_TIMEOUT_CONFIG_NAME = "OperationTimeout";
    private static final String RETRY_POLICY_CONFIG_NAME = "RetryPolicy";
    private static final String KEY_VALUE_SEPARATOR = "=";
    private static final String KEY_VALUE_PAIR_DELIMITER = ";";
    private static final String ALL_KEY_ENUMERATE_REGEX = "(Hostname|Endpoint|SharedAccessKeyName|SharedAccessKey|SharedAccessSignatureToken|EntityPath|OperationTimeout|RetryPolicy)";
    private static final String KEYS_WITH_DELIMITERS_REGEX = ";(Hostname|Endpoint|SharedAccessKeyName|SharedAccessKey|SharedAccessSignatureToken|EntityPath|OperationTimeout|RetryPolicy)=";
    private String connectionString;
    private URI endpoint;
    private String sharedAccessKeyName;
    private String sharedAccessKey;
    private String sharedAccessSingatureToken;
    private String entityPath;
    private Duration operationTimeout;
    private RetryPolicy retryPolicy;
    public static final Duration DefaultOperationTimeout = Duration.ofSeconds(30L);

    private ConnectionStringBuilder(URI endpointAddress, String entityPath, Duration operationTimeout, RetryPolicy retryPolicy) {
        this.endpoint = endpointAddress;
        this.operationTimeout = operationTimeout;
        this.retryPolicy = retryPolicy;
        this.entityPath = entityPath;
    }

    private ConnectionStringBuilder(URI endpointAddress, String entityPath, String sharedAccessKeyName, String sharedAccessKey, Duration operationTimeout, RetryPolicy retryPolicy) {
        this(endpointAddress, entityPath, operationTimeout, retryPolicy);
        this.sharedAccessKey = sharedAccessKey;
        this.sharedAccessKeyName = sharedAccessKeyName;
    }

    private ConnectionStringBuilder(URI endpointAddress, String entityPath, String sharedAccessSingatureToken, Duration operationTimeout, RetryPolicy retryPolicy) {
        this(endpointAddress, entityPath, operationTimeout, retryPolicy);
        this.sharedAccessSingatureToken = sharedAccessSingatureToken;
    }

    private ConnectionStringBuilder(String namespaceName, String entityPath, String sharedAccessKeyName, String sharedAccessKey, Duration operationTimeout, RetryPolicy retryPolicy) {
        this(Util.convertNamespaceToEndPointURI(namespaceName), entityPath, sharedAccessKeyName, sharedAccessKey, operationTimeout, retryPolicy);
    }

    private ConnectionStringBuilder(String namespaceName, String entityPath, String sharedAccessSingatureToken, Duration operationTimeout, RetryPolicy retryPolicy) {
        this(Util.convertNamespaceToEndPointURI(namespaceName), entityPath, sharedAccessSingatureToken, operationTimeout, retryPolicy);
    }

    public ConnectionStringBuilder(String namespaceName, String entityPath, String sharedAccessKeyName, String sharedAccessKey) {
        this(namespaceName, entityPath, sharedAccessKeyName, sharedAccessKey, DefaultOperationTimeout, RetryPolicy.getDefault());
    }

    public ConnectionStringBuilder(String namespaceName, String entityPath, String sharedAccessSingature) {
        this(namespaceName, entityPath, sharedAccessSingature, DefaultOperationTimeout, RetryPolicy.getDefault());
    }

    public ConnectionStringBuilder(URI endpointAddress, String entityPath, String sharedAccessKeyName, String sharedAccessKey) {
        this(endpointAddress, entityPath, sharedAccessKeyName, sharedAccessKey, DefaultOperationTimeout, RetryPolicy.getDefault());
    }

    public ConnectionStringBuilder(URI endpointAddress, String entityPath, String sharedAccessSingature) {
        this(endpointAddress, entityPath, sharedAccessSingature, DefaultOperationTimeout, RetryPolicy.getDefault());
    }

    public ConnectionStringBuilder(String connectionString) {
        this.parseConnectionString(connectionString);
    }

    public ConnectionStringBuilder(String namespaceConnectionString, String entityPath) {
        this(namespaceConnectionString);
        this.entityPath = entityPath;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public String getSasKey() {
        return this.sharedAccessKey;
    }

    public String getSasKeyName() {
        return this.sharedAccessKeyName;
    }

    public String getSharedAccessSignatureToken() {
        return this.sharedAccessSingatureToken;
    }

    public String getEntityPath() {
        return this.entityPath;
    }

    public Duration getOperationTimeout() {
        return this.operationTimeout == null ? DefaultOperationTimeout : this.operationTimeout;
    }

    public void setOperationTimeout(Duration operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy == null ? RetryPolicy.getDefault() : this.retryPolicy;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public String toString() {
        if (StringUtil.isNullOrWhiteSpace(this.connectionString)) {
            StringBuilder connectionStringBuilder = new StringBuilder();
            if (this.endpoint != null) {
                connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", ENDPOINT_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.endpoint.toString(), KEY_VALUE_PAIR_DELIMITER));
            }
            if (!StringUtil.isNullOrWhiteSpace(this.entityPath)) {
                connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", ENTITY_PATH_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.entityPath, KEY_VALUE_PAIR_DELIMITER));
            }
            if (!StringUtil.isNullOrWhiteSpace(this.sharedAccessKeyName)) {
                connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", SHARED_ACCESS_KEY_NAME_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.sharedAccessKeyName, KEY_VALUE_PAIR_DELIMITER));
            }
            if (!StringUtil.isNullOrWhiteSpace(this.sharedAccessKey)) {
                connectionStringBuilder.append(String.format(Locale.US, "%s%s%s", SHARED_ACCESS_KEY_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.sharedAccessKey));
            }
            if (!StringUtil.isNullOrWhiteSpace(this.sharedAccessSingatureToken)) {
                connectionStringBuilder.append(String.format(Locale.US, "%s%s%s", SHARED_ACCESS_SIGNATURE_TOKEN_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.sharedAccessSingatureToken));
            }
            if (this.operationTimeout != null) {
                connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", KEY_VALUE_PAIR_DELIMITER, OPERATION_TIMEOUT_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.operationTimeout.toString()));
            }
            if (this.retryPolicy != null) {
                connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", KEY_VALUE_PAIR_DELIMITER, RETRY_POLICY_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.retryPolicy.toString()));
            }
            this.connectionString = connectionStringBuilder.toString();
        }
        return this.connectionString;
    }

    private void parseConnectionString(String connectionString) {
        if (StringUtil.isNullOrWhiteSpace(connectionString)) {
            throw new IllegalConnectionStringFormatException(String.format("connectionString cannot be empty", new Object[0]));
        }
        String connection = KEY_VALUE_PAIR_DELIMITER + connectionString;
        Pattern keyValuePattern = Pattern.compile(KEYS_WITH_DELIMITERS_REGEX, 2);
        String[] values = keyValuePattern.split(connection);
        Matcher keys = keyValuePattern.matcher(connection);
        if (values == null || values.length <= 1 || keys.groupCount() == 0) {
            throw new IllegalConnectionStringFormatException("Connection String cannot be parsed.");
        }
        if (!StringUtil.isNullOrWhiteSpace(values[0])) {
            throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Cannot parse part of ConnectionString: %s", values[0]));
        }
        int valueIndex = 0;
        while (keys.find()) {
            String key = keys.group();
            key = key.substring(1, key.length() - 1);
            if (values.length < ++valueIndex + 1) {
                throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Value for the connection string parameter name: %s, not found", key));
            }
            if (key.equalsIgnoreCase(ENDPOINT_CONFIG_NAME)) {
                if (this.endpoint != null) {
                    throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Multiple %s and/or %s detected. Make sure only one is defined", ENDPOINT_CONFIG_NAME, HOSTNAME_CONFIG_NAME));
                }
                try {
                    this.endpoint = new URI(values[valueIndex]);
                    continue;
                }
                catch (URISyntaxException exception) {
                    throw new IllegalConnectionStringFormatException(String.format(Locale.US, "%s should be in format scheme://fullyQualifiedServiceBusNamespaceEndpointName", ENDPOINT_CONFIG_NAME), exception);
                }
            }
            if (key.equalsIgnoreCase(HOSTNAME_CONFIG_NAME)) {
                if (this.endpoint != null) {
                    throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Multiple %s and/or %s detected. Make sure only one is defined", ENDPOINT_CONFIG_NAME, HOSTNAME_CONFIG_NAME));
                }
                try {
                    this.endpoint = new URI(String.format(Locale.US, END_POINT_RAW_FORMAT, values[valueIndex]));
                    continue;
                }
                catch (URISyntaxException exception) {
                    throw new IllegalConnectionStringFormatException(String.format(Locale.US, "%s should be a fully quantified host name address", HOSTNAME_CONFIG_NAME), exception);
                }
            }
            if (key.equalsIgnoreCase(SHARED_ACCESS_KEY_NAME_CONFIG_NAME)) {
                this.sharedAccessKeyName = values[valueIndex];
                continue;
            }
            if (key.equalsIgnoreCase(SHARED_ACCESS_KEY_CONFIG_NAME)) {
                this.sharedAccessKey = values[valueIndex];
                continue;
            }
            if (key.equalsIgnoreCase(SHARED_ACCESS_SIGNATURE_TOKEN_CONFIG_NAME)) {
                this.sharedAccessSingatureToken = values[valueIndex];
                continue;
            }
            if (key.equalsIgnoreCase(ENTITY_PATH_CONFIG_NAME)) {
                this.entityPath = values[valueIndex];
                continue;
            }
            if (key.equalsIgnoreCase(OPERATION_TIMEOUT_CONFIG_NAME)) {
                try {
                    this.operationTimeout = Duration.parse(values[valueIndex]);
                    continue;
                }
                catch (DateTimeParseException exception) {
                    throw new IllegalConnectionStringFormatException("Invalid value specified for property 'Duration' in the ConnectionString.", exception);
                }
            }
            if (key.equalsIgnoreCase(RETRY_POLICY_CONFIG_NAME)) {
                RetryPolicy retryPolicy = values[valueIndex].equals("Default") ? RetryPolicy.getDefault() : (this.retryPolicy = values[valueIndex].equals("NoRetry") ? RetryPolicy.getNoRetry() : null);
                if (this.retryPolicy != null) continue;
                throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Connection string parameter '%s'='%s' is not recognized", RETRY_POLICY_CONFIG_NAME, values[valueIndex]));
            }
            throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Illegal connection string parameter name: %s", key));
        }
    }

    public String toLoggableString() {
        StringBuilder connectionStringBuilder = new StringBuilder();
        if (this.endpoint != null) {
            connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", ENDPOINT_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.endpoint.toString(), KEY_VALUE_PAIR_DELIMITER));
        }
        if (!StringUtil.isNullOrWhiteSpace(this.entityPath)) {
            connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", ENTITY_PATH_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.entityPath, KEY_VALUE_PAIR_DELIMITER));
        }
        return connectionStringBuilder.toString();
    }
}

