/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.primitives;

import com.microsoft.azure.servicebus.primitives.ExceptionUtil;
import com.microsoft.azure.servicebus.primitives.MessagingEntityType;
import com.microsoft.azure.servicebus.primitives.MessagingFactory;
import com.microsoft.azure.servicebus.primitives.RequestResponseLink;
import com.microsoft.azure.servicebus.primitives.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestResponseLinkcache {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(RequestResponseLinkcache.class);
    private Object lock = new Object();
    private final MessagingFactory underlyingFactory;
    private HashMap<String, RequestResponseLinkWrapper> pathToRRLinkMap;

    public RequestResponseLinkcache(MessagingFactory underlyingFactory) {
        this.underlyingFactory = underlyingFactory;
        this.pathToRRLinkMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<RequestResponseLink> obtainRequestResponseLinkAsync(String entityPath, MessagingEntityType entityType) {
        RequestResponseLinkWrapper wrapper;
        Object object = this.lock;
        synchronized (object) {
            wrapper = this.pathToRRLinkMap.get(entityPath);
            if (wrapper == null) {
                wrapper = new RequestResponseLinkWrapper(this.underlyingFactory, entityPath, entityType);
                this.pathToRRLinkMap.put(entityPath, wrapper);
            }
        }
        return wrapper.acquireReferenceAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRequestResponseLink(String entityPath) {
        RequestResponseLinkWrapper wrapper;
        Object object = this.lock;
        synchronized (object) {
            wrapper = this.pathToRRLinkMap.get(entityPath);
        }
        if (wrapper != null) {
            wrapper.releaseReference();
        }
    }

    public CompletableFuture<Void> freeAsync() {
        TRACE_LOGGER.info("Closing all cached request-response links");
        ArrayList<CompletableFuture<Void>> closeFutures = new ArrayList<CompletableFuture<Void>>();
        for (RequestResponseLinkWrapper wrapper : this.pathToRRLinkMap.values()) {
            closeFutures.add(wrapper.forceCloseAsync());
        }
        this.pathToRRLinkMap.clear();
        return CompletableFuture.allOf(closeFutures.toArray(new CompletableFuture[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeWrapperFromCache(String entityPath) {
        Object object = this.lock;
        synchronized (object) {
            this.pathToRRLinkMap.remove(entityPath);
        }
    }

    private class RequestResponseLinkWrapper {
        private Object lock = new Object();
        private final MessagingFactory underlyingFactory;
        private final String entityPath;
        private final MessagingEntityType entityType;
        private RequestResponseLink requestResponseLink;
        private int referenceCount;
        private ArrayList<CompletableFuture<RequestResponseLink>> waiters;

        public RequestResponseLinkWrapper(MessagingFactory underlyingFactory, String entityPath, MessagingEntityType entityType) {
            this.underlyingFactory = underlyingFactory;
            this.entityPath = entityPath;
            this.entityType = entityType;
            this.requestResponseLink = null;
            this.referenceCount = 0;
            this.waiters = new ArrayList();
            this.createRequestResponseLinkAsync();
        }

        private void createRequestResponseLinkAsync() {
            String requestResponseLinkPath = RequestResponseLink.getManagementNodeLinkPath(this.entityPath);
            String sasTokenAudienceURI = String.format("amqp://%s/%s", this.underlyingFactory.getHostName(), this.entityPath);
            TRACE_LOGGER.debug("Creating requestresponselink to '{}'", (Object)requestResponseLinkPath);
            RequestResponseLink.createAsync(this.underlyingFactory, StringUtil.getShortRandomString() + "-RequestResponse", requestResponseLinkPath, sasTokenAudienceURI, this.entityType).handleAsync((rrlink, ex) -> {
                Object object = this.lock;
                synchronized (object) {
                    if (ex == null) {
                        TRACE_LOGGER.info("Created requestresponselink to '{}'", (Object)requestResponseLinkPath);
                        this.requestResponseLink = rrlink;
                        for (CompletableFuture<RequestResponseLink> waiter : this.waiters) {
                            ++this.referenceCount;
                            waiter.complete(this.requestResponseLink);
                        }
                    } else {
                        Throwable cause = ExceptionUtil.extractAsyncCompletionCause(ex);
                        TRACE_LOGGER.error("Creating requestresponselink to '{}' failed.", (Object)requestResponseLinkPath, (Object)cause);
                        RequestResponseLinkcache.this.removeWrapperFromCache(this.entityPath);
                        for (CompletableFuture<RequestResponseLink> waiter : this.waiters) {
                            waiter.completeExceptionally(cause);
                        }
                    }
                }
                return null;
            }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompletableFuture<RequestResponseLink> acquireReferenceAsync() {
            Object object = this.lock;
            synchronized (object) {
                if (this.requestResponseLink == null) {
                    CompletableFuture<RequestResponseLink> waiter = new CompletableFuture<RequestResponseLink>();
                    this.waiters.add(waiter);
                    return waiter;
                }
                ++this.referenceCount;
                return CompletableFuture.completedFuture(this.requestResponseLink);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseReference() {
            Object object = this.lock;
            synchronized (object) {
                if (--this.referenceCount == 0) {
                    RequestResponseLinkcache.this.removeWrapperFromCache(this.entityPath);
                    TRACE_LOGGER.info("Closing requestresponselink to '{}'", (Object)this.requestResponseLink.getLinkPath());
                    this.requestResponseLink.closeAsync();
                }
            }
        }

        public CompletableFuture<Void> forceCloseAsync() {
            TRACE_LOGGER.info("Force closing requestresponselink to '{}'", (Object)this.requestResponseLink.getLinkPath());
            return this.requestResponseLink.closeAsync();
        }
    }
}

