/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.security;

import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.azure.servicebus.security.AzureActiveDirectoryTokenProvider;
import com.microsoft.azure.servicebus.security.ManagedServiceIdentityTokenProvider;
import com.microsoft.azure.servicebus.security.SecurityToken;
import com.microsoft.azure.servicebus.security.SharedAccessSignatureTokenProvider;
import java.net.MalformedURLException;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;

public abstract class TokenProvider {
    public abstract CompletableFuture<SecurityToken> getSecurityTokenAsync(String var1);

    public static TokenProvider createSharedAccessSignatureTokenProvider(String sasKeyName, String sasKey) {
        return new SharedAccessSignatureTokenProvider(sasKeyName, sasKey, 1200);
    }

    public static TokenProvider createSharedAccessSignatureTokenProvider(String sasToken, Instant sasTokenValidUntil) {
        return new SharedAccessSignatureTokenProvider(sasToken, sasTokenValidUntil);
    }

    public static TokenProvider createAzureActiveDirectoryTokenProvider(String authorityUrl, String clientId, String userName, String password) throws MalformedURLException {
        AuthenticationContext authContext = TokenProvider.createAuthenticationContext(authorityUrl);
        return new AzureActiveDirectoryTokenProvider(authContext, clientId, userName, password);
    }

    public static TokenProvider createAzureActiveDirectoryTokenProvider(String authorityUrl, String clientId, String clientSecret) throws MalformedURLException {
        AuthenticationContext authContext = TokenProvider.createAuthenticationContext(authorityUrl);
        return new AzureActiveDirectoryTokenProvider(authContext, new ClientCredential(clientId, clientSecret));
    }

    public static TokenProvider createManagedServiceIdentityTokenProvider() {
        return new ManagedServiceIdentityTokenProvider();
    }

    private static AuthenticationContext createAuthenticationContext(String authorityUrl) throws MalformedURLException {
        return new AuthenticationContext(authorityUrl, true, (ExecutorService)ForkJoinPool.commonPool());
    }
}

