/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.springcloud;

import com.microsoft.azure.maven.exception.MavenDecryptException;
import com.microsoft.azure.maven.springcloud.AbstractMojoBase;
import com.microsoft.azure.maven.springcloud.config.AppDeploymentRawConfig;
import com.microsoft.azure.maven.springcloud.config.AppRawConfig;
import com.microsoft.azure.maven.springcloud.config.ConfigurationPrompter;
import com.microsoft.azure.maven.springcloud.config.ConfigurationUpdater;
import com.microsoft.azure.maven.utils.MavenConfigUtils;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.auth.exception.LoginFailureException;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.exception.InvalidConfigurationException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import com.microsoft.azure.toolkit.lib.springcloud.AzureSpringCloud;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudCluster;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudClusterModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.atteo.evo.inflector.English;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.dom4j.DocumentException;

@Mojo(name="config", requiresDirectInvocation=true, aggregator=true)
public class ConfigMojo
extends AbstractMojoBase {
    private static final String DEPLOYMENT_TAG = "deployment";
    private static final List<String> APP_PROPERTIES;
    private static final List<String> DEPLOYMENT_PROPERTIES;
    private boolean parentMode;
    private ConfigurationPrompter wrapper;
    private List<MavenProject> targetProjects = new ArrayList<MavenProject>();
    private List<MavenProject> publicProjects;
    private Map<MavenProject, String> appNameByProject;
    private AppRawConfig appSettings;
    private AppDeploymentRawConfig deploymentSettings;
    @Parameter(defaultValue="${mojoExecution}")
    protected MojoExecution mojoExecution;
    @Parameter(property="advancedOptions")
    private boolean advancedOptions;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @AzureOperation(name="springcloud.config_mojo", type=AzureOperation.Type.ACTION)
    protected void doExecute() throws AzureExecutionException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            if (!this.settings.isInteractiveMode()) {
                throw new UnsupportedOperationException("The goal 'config' must be run at interactive mode.");
            }
            if (!MavenConfigUtils.isPomPackaging((MavenProject)this.project) && !MavenConfigUtils.isJarPackaging((MavenProject)this.project)) {
                throw new UnsupportedOperationException(String.format("The project (%s) with packaging %s is not supported for Azure Spring Apps.", this.project.getName(), this.project.getPackaging()));
            }
            if (this.isProjectConfigured(this.project)) {
                this.getLog().warn((CharSequence)String.format("Project (%s) is already configured and won't be affected by this command.", this.project.getName()));
            } else {
                this.appSettings = new AppRawConfig();
                this.deploymentSettings = new AppDeploymentRawConfig();
                this.parentMode = MavenConfigUtils.isPomPackaging((MavenProject)this.project);
                if (this.parentMode && this.advancedOptions) {
                    throw new UnsupportedOperationException("The \"advancedOptions\" mode is not supported at parent folder.");
                }
                PluginParameterExpressionEvaluator expressionEvaluator = new PluginParameterExpressionEvaluator(this.session, this.mojoExecution);
                try {
                    this.wrapper = new ConfigurationPrompter((ExpressionEvaluator)expressionEvaluator, this.getLog());
                    this.wrapper.initialize();
                    this.wrapper.putCommonVariable("project", this.project);
                    this.selectProjects();
                    if (this.targetProjects != null && !this.targetProjects.isEmpty()) {
                        this.getAzureAccount();
                        this.promptAndSelectSubscription();
                        this.selectAppCluster();
                        this.configCommon();
                        this.confirmAndSave();
                    }
                }
                catch (MavenDecryptException | LoginFailureException | InvalidConfigurationException | IOException | UnsupportedOperationException e) {
                    throw new AzureExecutionException(e.getMessage());
                }
                finally {
                    if (this.wrapper != null) {
                        try {
                            this.wrapper.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private void configCommon() throws IOException, InvalidConfigurationException {
        this.configureAppName();
        this.configurePublic();
        this.configureInstanceCount();
        this.configureCpu();
        this.configureMemory();
        if (this.notEnterpriseTier()) {
            this.configureJavaVersion();
        }
        this.configureJvmOptions();
    }

    private boolean notEnterpriseTier() {
        SpringCloudCluster cluster = (SpringCloudCluster)((AzureSpringCloud)Azure.az(AzureSpringCloud.class)).clusters(this.subscriptionId).get(this.appSettings.getClusterName(), null);
        return !Objects.nonNull(cluster) || !cluster.isEnterpriseTier();
    }

    private void selectProjects() throws IOException, InvalidConfigurationException {
        if (this.parentMode) {
            List allProjects = this.session.getAllProjects().stream().filter(MavenConfigUtils::isJarPackaging).collect(Collectors.toList());
            ArrayList<MavenProject> configuredProjects = new ArrayList<MavenProject>();
            for (MavenProject proj : allProjects) {
                if (this.isProjectConfigured(proj)) {
                    configuredProjects.add(proj);
                    continue;
                }
                this.targetProjects.add(proj);
            }
            this.wrapper.putCommonVariable("projects", this.targetProjects);
            if (!configuredProjects.isEmpty()) {
                this.getLog().warn((CharSequence)String.format("The following child %s %s already configured: ", English.plural((String)"module", (int)configuredProjects.size()), configuredProjects.size() > 1 ? "are" : "is"));
                for (MavenProject proj : configuredProjects) {
                    System.out.println("    " + TextUtils.yellow((String)proj.getName()));
                }
            } else if (this.targetProjects.isEmpty()) {
                this.getLog().warn((CharSequence)"There are no projects in current folder with package 'jar'.");
                return;
            }
            this.targetProjects = this.wrapper.handleMultipleCase("select-projects", this.targetProjects, MavenProject::getName);
        } else {
            this.targetProjects.add(this.project);
        }
        this.wrapper.putCommonVariable("projects", this.targetProjects);
    }

    private void configureJavaVersion() throws IOException, InvalidConfigurationException {
        this.deploymentSettings.setRuntimeVersion(this.wrapper.handle("configure-java-version", this.autoUseDefault()));
    }

    private void configureJvmOptions() throws IOException, InvalidConfigurationException {
        this.deploymentSettings.setJvmOptions(this.wrapper.handle("configure-jvm-options", this.autoUseDefault()));
    }

    private void configureCpu() throws IOException, InvalidConfigurationException {
        this.deploymentSettings.setCpu(this.wrapper.handle("configure-cpu", this.autoUseDefault()));
    }

    private void configureMemory() throws IOException, InvalidConfigurationException {
        this.deploymentSettings.setMemoryInGB(this.wrapper.handle("configure-memory", this.autoUseDefault()));
    }

    private void configureInstanceCount() throws IOException, InvalidConfigurationException {
        this.deploymentSettings.setInstanceCount(this.wrapper.handle("configure-instance-count", this.autoUseDefault()));
    }

    private boolean autoUseDefault() {
        return !this.advancedOptions || this.parentMode;
    }

    private void confirmAndSave() throws IOException {
        LinkedHashMap<String, String> changesToConfirm = new LinkedHashMap<String, String>();
        changesToConfirm.put("Subscription id", this.subscriptionId);
        changesToConfirm.put("Azure Spring Apps name", this.appSettings.getClusterName());
        if (this.parentMode) {
            if (this.publicProjects != null && this.publicProjects.size() > 0) {
                changesToConfirm.put("Public " + English.plural((String)"app", (int)this.publicProjects.size()), this.publicProjects.stream().map(MavenProject::getName).collect(Collectors.joining(",")));
            }
            changesToConfirm.put("App " + English.plural((String)"name", (int)this.appNameByProject.size()), String.join((CharSequence)",", this.appNameByProject.values()));
            this.wrapper.confirmChanges(changesToConfirm, this::saveConfigurationToPom);
        } else {
            changesToConfirm.put("App name", this.appSettings.getAppName());
            changesToConfirm.put("Public access", this.appSettings.getIsPublic());
            changesToConfirm.put("Instance count", this.deploymentSettings.getInstanceCount());
            changesToConfirm.put("CPU count", this.deploymentSettings.getCpu());
            changesToConfirm.put("Memory size(GB)", this.deploymentSettings.getMemoryInGB());
            changesToConfirm.put("JVM options", this.deploymentSettings.getJvmOptions());
            if (this.notEnterpriseTier()) {
                changesToConfirm.put("Runtime Java version", this.deploymentSettings.getRuntimeVersion());
            }
            this.wrapper.confirmChanges(changesToConfirm, this::saveConfigurationToPom);
        }
    }

    private Integer saveConfigurationToPom() {
        this.telemetries.put("isPomFileModified", String.valueOf(true));
        this.appSettings.setSubscriptionId(this.subscriptionId);
        for (MavenProject proj : this.targetProjects) {
            if (this.parentMode) {
                this.appSettings.setAppName(this.appNameByProject.get(proj));
                this.appSettings.setIsPublic(this.publicProjects != null && this.publicProjects.contains(proj) ? "true" : "false");
            }
            this.saveConfigurationToProject(proj);
        }
        if (this.parentMode) {
            ConfigurationUpdater.updateAppConfigToPom(null, this.project, this.plugin);
        }
        return this.targetProjects.size();
    }

    private void saveConfigurationToProject(MavenProject proj) throws DocumentException, IOException {
        this.appSettings.setDeployment(this.deploymentSettings);
        ConfigurationUpdater.updateAppConfigToPom(this.appSettings, proj, this.plugin);
    }

    private void configurePublic() throws IOException, InvalidConfigurationException {
        if (this.parentMode) {
            this.publicProjects = this.wrapper.handleMultipleCase("configure-public-list", this.targetProjects, MavenProject::getName);
        } else {
            this.appSettings.setIsPublic(this.wrapper.handle("configure-public", false));
        }
    }

    private void configureAppName() throws IOException, InvalidConfigurationException {
        if (StringUtils.isNotBlank((CharSequence)this.appName) && this.parentMode) {
            throw new UnsupportedOperationException("Cannot specify appName in parent mode.");
        }
        if (this.parentMode) {
            this.appNameByProject = new HashMap<MavenProject, String>();
            for (MavenProject proj : this.targetProjects) {
                this.wrapper.putCommonVariable("project", proj);
                this.appNameByProject.put(proj, this.wrapper.handle("configure-app-name", this.parentMode, this.appName));
            }
            this.wrapper.putCommonVariable("project", this.project);
            String duplicateAppNames = this.appNameByProject.values().stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(t -> (Long)t.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.joining(","));
            if (StringUtils.isNotBlank((CharSequence)duplicateAppNames)) {
                throw new InvalidConfigurationException(String.format("Cannot apply default appName due to duplicate: %s", duplicateAppNames));
            }
        } else {
            this.appSettings.setAppName(this.wrapper.handle("configure-app-name", false, this.appName));
        }
    }

    private void selectAppCluster() throws IOException, InvalidConfigurationException {
        SpringCloudClusterModule az = ((AzureSpringCloud)Azure.az(AzureSpringCloud.class)).clusters(this.subscriptionId);
        if (StringUtils.isNotBlank((CharSequence)this.clusterName)) {
            SpringCloudCluster cluster = (SpringCloudCluster)az.get(this.clusterName, null);
            if (Objects.nonNull(cluster) && cluster.exists()) {
                this.appSettings.setClusterName(cluster.getName());
                return;
            }
            this.getLog().warn((CharSequence)String.format("Cannot find Azure Apps with name: %s.", TextUtils.yellow((String)this.clusterName)));
        }
        List clusters = az.list();
        this.wrapper.putCommonVariable("clusters", clusters);
        SpringCloudCluster targetAppCluster = this.wrapper.handleSelectOne("select-ASC", clusters, null, AbstractAzResource::getName);
        if (targetAppCluster != null) {
            this.appSettings.setClusterName(targetAppCluster.name());
            this.getLog().info((CharSequence)String.format("Using Azure Spring Apps: %s", TextUtils.blue((String)targetAppCluster.name())));
        }
    }

    protected void promptAndSelectSubscription() {
        if (StringUtils.isBlank((CharSequence)this.subscriptionId)) {
            List subscriptions = ((AzureAccount)Azure.az(AzureAccount.class)).account().getSubscriptions();
            this.subscriptionId = CollectionUtils.isNotEmpty((Collection)subscriptions) && subscriptions.size() == 1 ? ((Subscription)subscriptions.get(0)).getId() : this.promptSubscription();
        }
        this.selectSubscription();
    }

    private String promptSubscription() throws IOException, InvalidConfigurationException {
        List subscriptions = ((AzureAccount)Azure.az(AzureAccount.class)).account().getSubscriptions();
        List selectedSubscriptions = ((AzureAccount)Azure.az(AzureAccount.class)).account().getSelectedSubscriptions();
        this.wrapper.putCommonVariable("subscriptions", subscriptions);
        Subscription select = this.wrapper.handleSelectOne("select-subscriptions", subscriptions, CollectionUtils.isNotEmpty((Collection)selectedSubscriptions) ? (Subscription)selectedSubscriptions.get(0) : null, t -> String.format("%s (%s)", t.getName(), t.getId()));
        ((AzureAccount)Azure.az(AzureAccount.class)).account().selectSubscription(Collections.singletonList(select.getId()));
        return select.getId();
    }

    private boolean isProjectConfigured(MavenProject proj) {
        String pluginIdentifier = this.plugin.getPluginLookupKey();
        Xpp3Dom configuration = MavenConfigUtils.getPluginConfiguration((MavenProject)proj, (String)pluginIdentifier);
        if (configuration == null) {
            return false;
        }
        for (Xpp3Dom child : configuration.getChildren()) {
            if (!APP_PROPERTIES.contains(child.getName())) continue;
            return true;
        }
        if (configuration.getChild(DEPLOYMENT_TAG) != null) {
            for (Xpp3Dom child : configuration.getChild(DEPLOYMENT_TAG).getChildren()) {
                if (!DEPLOYMENT_PROPERTIES.contains(child.getName())) continue;
                return true;
            }
        }
        return false;
    }

    static {
        ConfigMojo.ajc$preClinit();
        APP_PROPERTIES = Arrays.asList("appName", "isPublic");
        DEPLOYMENT_PROPERTIES = Arrays.asList("cpu", "memoryInGB", "instanceCount", "jvmOptions", "runtimeVersion");
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ConfigMojo.java", ConfigMojo.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "doExecute", "com.microsoft.azure.maven.springcloud.ConfigMojo", "", "", "com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException", "void"), 108);
    }
}

