/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.springcloud;

import com.microsoft.azure.maven.prompt.DefaultPrompter;
import com.microsoft.azure.maven.springcloud.AbstractMojoBase;
import com.microsoft.azure.maven.utils.MavenConfigUtils;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.IArtifact;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment;
import com.microsoft.azure.toolkit.lib.springcloud.Utils;
import com.microsoft.azure.toolkit.lib.springcloud.config.SpringCloudAppConfig;
import com.microsoft.azure.toolkit.lib.springcloud.config.SpringCloudDeploymentConfig;
import com.microsoft.azure.toolkit.lib.springcloud.task.DeploySpringCloudAppTask;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="deploy")
public class DeployMojo
extends AbstractMojoBase {
    private static final Logger log;
    private static final int GET_URL_TIMEOUT = 60;
    private static final int GET_STATUS_TIMEOUT = 180;
    private static final String PROJECT_SKIP = "Packaging type is pom, taking no actions.";
    private static final String PROJECT_NO_CONFIGURATION = "Configuration does not exist, taking no actions.";
    private static final String PROJECT_NOT_SUPPORT = "`azure-spring-apps:deploy` does not support maven project with packaging %s, only jar is supported";
    private static final String GET_DEPLOYMENT_STATUS_TIMEOUT = "Deployment succeeded but the app is still starting, you can check the app status from Azure Portal.";
    private static final String CONFIRM_PROMPT_START = "`azure-spring-apps:deploy` will perform the following tasks";
    private static final String CONFIRM_PROMPT_CONFIRM = "Perform the above tasks? (Y/n):";
    @Parameter(property="noWait")
    private boolean noWait;
    @Parameter(property="prompt")
    private boolean prompt;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @AzureOperation(name="springcloud.deploy_mojo", type=AzureOperation.Type.ACTION)
    protected void doExecute() throws Throwable {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            boolean shouldSkipConfirm;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.getAzureAccount();
            this.selectSubscription();
            SpringCloudAppConfig appConfig = this.getConfiguration();
            SpringCloudDeploymentConfig deploymentConfig = appConfig.getDeployment();
            Optional.ofNullable(deploymentConfig).map(SpringCloudDeploymentConfig::getArtifact).map(IArtifact::getFile).orElseThrow(() -> new AzureToolkitRuntimeException("No artifact is specified to deploy."));
            DeploySpringCloudAppTask task = new DeploySpringCloudAppTask(appConfig);
            List tasks = task.getSubTasks();
            boolean bl = shouldSkipConfirm = !this.prompt || this.settings != null && !this.settings.isInteractiveMode();
            if (!shouldSkipConfirm && !this.confirm(tasks)) {
                log.warn("Deployment is cancelled!");
            } else {
                SpringCloudDeployment deployment = task.doExecute();
                if (!this.noWait && Optional.ofNullable(deploymentConfig).map(SpringCloudDeploymentConfig::getArtifact).map(IArtifact::getFile).isPresent() && !deployment.waitUntilReady(180)) {
                    log.warn(GET_DEPLOYMENT_STATUS_TIMEOUT);
                }
                this.printStatus(deployment);
                this.printPublicUrl((SpringCloudApp)deployment.getParent());
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    protected boolean confirm(List<AzureTask<?>> tasks) throws MojoFailureException {
        try {
            DefaultPrompter prompter = new DefaultPrompter();
            System.out.println(CONFIRM_PROMPT_START);
            tasks.stream().filter(t -> Objects.nonNull(t.getTitle()) && StringUtils.isNotBlank((CharSequence)t.getTitle().toString())).forEach(t -> System.out.printf("\t- %s%n", t.getTitle()));
            return prompter.promoteYesNo(CONFIRM_PROMPT_CONFIRM, Boolean.valueOf(true), true);
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    protected void printPublicUrl(SpringCloudApp app) {
        if (!app.isPublicEndpointEnabled()) {
            return;
        }
        log.info("Getting public url of app({})...", (Object)TextUtils.cyan((String)app.name()));
        String publicUrl = app.getApplicationUrl();
        if (!this.noWait && StringUtils.isEmpty((CharSequence)publicUrl)) {
            publicUrl = (String)Utils.pollUntil(() -> {
                app.refresh();
                return app.getApplicationUrl();
            }, StringUtils::isNotBlank, (int)60);
        }
        if (StringUtils.isEmpty((CharSequence)publicUrl)) {
            log.warn("Failed to get application url");
        } else {
            log.info("Application url: {}", (Object)TextUtils.cyan((String)publicUrl));
        }
    }

    protected void printStatus(SpringCloudDeployment deployment) {
        log.info("Deployment Status: {}", (Object)DeployMojo.color(deployment.getStatus()));
        deployment.getInstances().forEach(instance -> log.info(String.format("  InstanceName:%-10s  Status:%-10s Reason:%-10s DiscoverStatus:%-10s", instance.name(), DeployMojo.color(instance.status()), instance.reason(), instance.discoveryStatus())));
    }

    private static String color(String status) {
        switch (status.toUpperCase()) {
            case "RUNNING": {
                return TextUtils.green((String)status);
            }
            case "FAILED": 
            case "STOPPED": {
                return TextUtils.red((String)status);
            }
            case "UNKNOWN": {
                return status;
            }
        }
        return TextUtils.blue((String)status);
    }

    protected boolean checkProjectPackaging(MavenProject project) throws MojoExecutionException {
        if (MavenConfigUtils.isJarPackaging((MavenProject)project)) {
            return true;
        }
        if (MavenConfigUtils.isPomPackaging((MavenProject)project)) {
            log.info(PROJECT_SKIP);
            return false;
        }
        throw new MojoExecutionException(String.format(PROJECT_NOT_SUPPORT, project.getPackaging()));
    }

    protected boolean checkConfiguration() {
        String pluginKey = this.plugin.getPluginLookupKey();
        Xpp3Dom pluginDom = MavenConfigUtils.getPluginConfiguration((MavenProject)this.project, (String)pluginKey);
        if (pluginDom == null || pluginDom.getChildren().length == 0) {
            log.warn(PROJECT_NO_CONFIGURATION);
            return false;
        }
        return true;
    }

    protected boolean isSkipMojo() {
        return !this.checkProjectPackaging(this.project) || !this.checkConfiguration();
    }

    static {
        DeployMojo.ajc$preClinit();
        log = LoggerFactory.getLogger(DeployMojo.class);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DeployMojo.java", DeployMojo.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "doExecute", "com.microsoft.azure.maven.springcloud.DeployMojo", "", "", "java.lang.Throwable", "void"), 71);
    }
}

