/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.springcloud.config;

import com.microsoft.azure.maven.springcloud.AbstractMojoBase;
import com.microsoft.azure.maven.springcloud.config.AppDeploymentMavenConfig;
import com.microsoft.azure.maven.utils.MavenArtifactUtils;
import com.microsoft.azure.toolkit.lib.common.model.IArtifact;
import com.microsoft.azure.toolkit.lib.springcloud.config.SpringCloudAppConfig;
import com.microsoft.azure.toolkit.lib.springcloud.config.SpringCloudDeploymentConfig;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.project.MavenProject;

public class ConfigurationParser {
    public SpringCloudAppConfig parse(AbstractMojoBase springMojo) {
        AppDeploymentMavenConfig rawConfig = springMojo.getDeployment();
        SpringCloudDeploymentConfig config = ConfigurationParser.toDeploymentConfig(rawConfig, springMojo);
        return SpringCloudAppConfig.builder().appName(springMojo.getAppName()).clusterName(springMojo.getClusterName()).deployment(config).runtimeVersion(config.getRuntimeVersion()).isPublic(springMojo.getIsPublic()).subscriptionId(springMojo.getSubscriptionId()).build();
    }

    private static SpringCloudDeploymentConfig toDeploymentConfig(AppDeploymentMavenConfig rawConfig, AbstractMojoBase mojo) {
        List artifacts = MavenArtifactUtils.getArtifacts(rawConfig.getResources());
        if (artifacts.isEmpty()) {
            artifacts.addAll(MavenArtifactUtils.getArtifactFiles((MavenProject)mojo.getProject()));
        }
        File artifact = MavenArtifactUtils.getExecutableJarFiles((Collection)artifacts);
        return SpringCloudDeploymentConfig.builder().cpu(rawConfig.getCpu()).deploymentName(rawConfig.getDeploymentName()).artifact((IArtifact)(artifact != null ? IArtifact.fromFile((File)artifact) : null)).enablePersistentStorage(rawConfig.isEnablePersistentStorage()).environment(rawConfig.getEnvironment()).instanceCount(rawConfig.getInstanceCount()).jvmOptions(rawConfig.getJvmOptions()).memoryInGB(rawConfig.getMemoryInGB()).runtimeVersion((String)StringUtils.firstNonEmpty((CharSequence[])new String[]{rawConfig.getRuntimeVersion(), mojo.getRuntimeVersion()})).build();
    }

    public static ConfigurationParser getInstance() {
        return Holder.parser;
    }

    private static class Holder {
        private static final ConfigurationParser parser = new ConfigurationParser();

        private Holder() {
        }
    }
}

