/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.springcloud.config;

import com.microsoft.azure.maven.springcloud.AbstractMojoBase;
import com.microsoft.azure.maven.springcloud.config.AppDeploymentMavenConfig;
import com.microsoft.azure.maven.utils.MavenArtifactUtils;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.IArtifact;
import com.microsoft.azure.toolkit.lib.springcloud.config.SpringCloudAppConfig;
import com.microsoft.azure.toolkit.lib.springcloud.config.SpringCloudDeploymentConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;

public class ConfigurationParser {
    public SpringCloudAppConfig parse(AbstractMojoBase springMojo) {
        AppDeploymentMavenConfig rawConfig = springMojo.getDeployment();
        SpringCloudDeploymentConfig config = ConfigurationParser.toDeploymentConfig(rawConfig, springMojo);
        return SpringCloudAppConfig.builder().appName(springMojo.getAppName()).resourceGroup(springMojo.getResourceGroup()).clusterName(springMojo.getClusterName()).deployment(config).runtimeVersion(config.getRuntimeVersion()).isPublic(springMojo.getIsPublic()).subscriptionId(springMojo.getSubscriptionId()).build();
    }

    private static SpringCloudDeploymentConfig toDeploymentConfig(AppDeploymentMavenConfig rawConfig, AbstractMojoBase mojo) {
        ArrayList artifacts = new ArrayList();
        Optional.ofNullable(rawConfig.getResources()).ifPresent(resources -> resources.forEach(resource -> {
            try {
                artifacts.addAll(MavenArtifactUtils.getArtifacts((Resource)resource));
            }
            catch (IllegalStateException e) {
                AzureMessager.getMessager().warning(String.format("'%s' doesn't exist or isn't a directory", resource.getDirectory()));
            }
        }));
        if (artifacts.isEmpty()) {
            artifacts.addAll(MavenArtifactUtils.getArtifactFiles((MavenProject)mojo.getProject()));
        }
        File artifact = MavenArtifactUtils.getExecutableJarFiles(artifacts);
        return SpringCloudDeploymentConfig.builder().cpu(rawConfig.getCpu()).deploymentName(rawConfig.getDeploymentName()).artifact((IArtifact)(artifact != null ? IArtifact.fromFile((File)artifact) : null)).enablePersistentStorage(rawConfig.isEnablePersistentStorage()).environment(rawConfig.getEnvironment()).instanceCount(rawConfig.getInstanceCount()).jvmOptions(rawConfig.getJvmOptions()).memoryInGB(rawConfig.getMemoryInGB()).runtimeVersion((String)StringUtils.firstNonEmpty((CharSequence[])new String[]{rawConfig.getRuntimeVersion(), mojo.getRuntimeVersion()})).build();
    }

    public static ConfigurationParser getInstance() {
        return Holder.parser;
    }

    private static class Holder {
        private static final ConfigurationParser parser = new ConfigurationParser();

        private Holder() {
        }
    }
}

