/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.springcloud.config;

import com.microsoft.azure.maven.springcloud.config.AppDeploymentRawConfig;
import com.microsoft.azure.maven.springcloud.config.AppRawConfig;
import com.microsoft.azure.maven.utils.MavenConfigUtils;
import com.microsoft.azure.maven.utils.PomUtils;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.keyvalue.DefaultMapEntry;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class ConfigurationUpdater {
    public static void updateAppConfigToPom(AppRawConfig config, MavenProject project, PluginDescriptor plugin) throws DocumentException, IOException {
        Element configNode;
        File pom = project.getFile();
        Element pluginNode = PomUtils.getPluginNode((PluginDescriptor)plugin, (File)pom);
        Element element = configNode = config != null ? ConfigurationUpdater.createOrUpdateAppConfigNode(pluginNode, config) : pluginNode;
        while (!(configNode.getParent() instanceof PomUtils.LocationAwareElement)) {
            configNode = configNode.getParent();
        }
        FileUtils.fileWrite((File)pom, (String)PomUtils.formatNode((String)FileUtils.fileRead((File)pom), (PomUtils.LocationAwareElement)((PomUtils.LocationAwareElement)configNode.getParent()), (Element)configNode));
    }

    private static Element createOrUpdateAppConfigNode(Element pluginNode, AppRawConfig config) {
        Element appConfigNode = PomUtils.getOrCreateNode((Element)pluginNode, (String[])new String[]{"configuration"});
        PomUtils.updateNode((Element)appConfigNode, ConfigurationUpdater.toMap(config));
        if (Objects.nonNull(config.getDeployment())) {
            ConfigurationUpdater.createOrUpdateDeploymentConfigNode(appConfigNode, config.getDeployment());
        }
        return appConfigNode;
    }

    private static Element createOrUpdateDeploymentConfigNode(Element appConfigNode, AppDeploymentRawConfig config) {
        Element deploymentConfigNode = PomUtils.getOrCreateNode((Element)appConfigNode, (String[])new String[]{"deployment"});
        PomUtils.updateNode((Element)deploymentConfigNode, ConfigurationUpdater.toMap(config));
        MavenConfigUtils.addResourcesConfig((Element)deploymentConfigNode, (List)MavenConfigUtils.getDefaultResources());
        return deploymentConfigNode;
    }

    public static Map<String, Object> toMap(AppRawConfig app) {
        return MapUtils.putAll(new LinkedHashMap(), (Object[])new Map.Entry[]{new DefaultMapEntry((Object)"subscriptionId", (Object)app.getSubscriptionId()), new DefaultMapEntry((Object)"resourceGroup", (Object)app.getResourceGroup()), new DefaultMapEntry((Object)"clusterName", (Object)app.getClusterName()), new DefaultMapEntry((Object)"appName", (Object)app.getAppName()), new DefaultMapEntry((Object)"isPublic", (Object)app.getIsPublic())});
    }

    public static Map<String, Object> toMap(AppDeploymentRawConfig deployment) {
        return MapUtils.putAll(new LinkedHashMap(), (Object[])new Map.Entry[]{new DefaultMapEntry((Object)"cpu", (Object)deployment.getCpu()), new DefaultMapEntry((Object)"memoryInGB", (Object)deployment.getMemoryInGB()), new DefaultMapEntry((Object)"instanceCount", (Object)deployment.getInstanceCount()), new DefaultMapEntry((Object)"jvmOptions", (Object)deployment.getJvmOptions()), new DefaultMapEntry((Object)"runtimeVersion", (Object)deployment.getRuntimeVersion())});
    }
}

